/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Energy;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class EnergyDuration
implements Comparable<EnergyDuration> {
    @NotNull
    private final ImmutableList<Common.Event> myEventList;
    private String myCalledBy = null;

    public EnergyDuration(@NotNull List<Common.Event> eventList) {
        assert (!eventList.isEmpty());
        this.myEventList = ImmutableList.copyOf(eventList);
    }

    @Override
    public int compareTo(@NotNull EnergyDuration another) {
        return (int)(this.getInitialTimestamp() - another.getInitialTimestamp());
    }

    public long getInitialTimestamp() {
        return ((Common.Event)this.myEventList.get(0)).getTimestamp();
    }

    @NotNull
    public String getName() {
        Kind kind = this.getKind();
        String namePart = "";
        switch (kind) {
            case WAKE_LOCK: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasWakeLockAcquired()) break;
                namePart = EnergyDuration.getWakeLockLevelName(((Common.Event)this.getEventList().get(0)).getEnergyEvent().getWakeLockAcquired().getLevel());
                break;
            }
            case ALARM: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasAlarmSet()) break;
                namePart = EnergyDuration.getAlarmTypeName(((Common.Event)this.getEventList().get(0)).getEnergyEvent().getAlarmSet().getType());
                break;
            }
            case LOCATION: {
                namePart = "Request";
                break;
            }
        }
        return !namePart.isEmpty() ? String.format("%s: %s", kind.getDisplayName(), namePart) : kind.getDisplayName();
    }

    @NotNull
    public String getDescription() {
        switch (this.getKind()) {
            case WAKE_LOCK: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasWakeLockAcquired()) break;
                return ((Common.Event)this.getEventList().get(0)).getEnergyEvent().getWakeLockAcquired().getTag();
            }
            case ALARM: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasAlarmSet()) break;
                Energy.AlarmSet alarmSet = ((Common.Event)this.getEventList().get(0)).getEnergyEvent().getAlarmSet();
                return alarmSet.hasOperation() ? alarmSet.getOperation().getCreatorPackage() : (alarmSet.hasListener() ? alarmSet.getListener().getTag() : "");
            }
            case JOB: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasJobScheduled()) break;
                Energy.JobInfo job = ((Common.Event)this.getEventList().get(0)).getEnergyEvent().getJobScheduled().getJob();
                return String.format("%d:%s", job.getJobId(), job.getServiceName());
            }
        }
        return "N/A";
    }

    @NotNull
    public Kind getKind() {
        return Kind.from(((Common.Event)this.myEventList.get(0)).getEnergyEvent());
    }

    @NotNull
    public ImmutableList<Common.Event> getEventList() {
        return this.myEventList;
    }

    @NotNull
    public static List<EnergyDuration> groupById(@NotNull List<Common.Event> events) {
        LinkedHashMap durationMap = new LinkedHashMap();
        for (Common.Event event : events) {
            if (durationMap.containsKey(event.getGroupId())) {
                ((List)durationMap.get(event.getGroupId())).add(event);
                continue;
            }
            ArrayList<Common.Event> list2 = new ArrayList<Common.Event>();
            list2.add(event);
            durationMap.put(event.getGroupId(), list2);
        }
        return ContainerUtil.map(durationMap.values(), list -> new EnergyDuration((List<Common.Event>)list));
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(EnergyDuration.class);
    }

    @NotNull
    public static String getWakeLockLevelName(@NotNull Energy.WakeLockAcquired.Level level) {
        switch (level) {
            case FULL_WAKE_LOCK: {
                return "Full";
            }
            case PARTIAL_WAKE_LOCK: {
                return "Partial";
            }
            case SCREEN_DIM_WAKE_LOCK: {
                return "Screen Dim";
            }
            case SCREEN_BRIGHT_WAKE_LOCK: {
                return "Screen Bright";
            }
            case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                return "Proximity Screen Off";
            }
        }
        return "N/A";
    }

    @NotNull
    public static String getAlarmTypeName(@NotNull Energy.AlarmSet.Type type) {
        switch (type) {
            case RTC: {
                return "RTC";
            }
            case RTC_WAKEUP: {
                return "RTC Wakeup";
            }
            case ELAPSED_REALTIME: {
                return "Elapsed Realtime";
            }
            case ELAPSED_REALTIME_WAKEUP: {
                return "Elapsed Realtime Wakeup";
            }
        }
        return "N/A";
    }

    @NotNull
    public static String getMetadataName(Energy.EnergyEventData.MetadataCase metadataCase) {
        switch (metadataCase) {
            case WAKE_LOCK_ACQUIRED: {
                return "Acquired";
            }
            case WAKE_LOCK_RELEASED: {
                return "Released";
            }
            case ALARM_SET: {
                return "Set";
            }
            case ALARM_FIRED: {
                return "Triggered";
            }
            case ALARM_CANCELLED: {
                return "Cancelled";
            }
            case JOB_SCHEDULED: {
                return "Scheduled";
            }
            case JOB_STARTED: {
                return "Started";
            }
            case JOB_STOPPED: {
                return "Stopped";
            }
            case JOB_FINISHED: {
                return "Finished";
            }
            case LOCATION_UPDATE_REQUESTED: {
                return "Requested";
            }
            case LOCATION_CHANGED: {
                return "Location Updated";
            }
            case LOCATION_UPDATE_REMOVED: {
                return "Request Removed";
            }
        }
        return "";
    }

    @NotNull
    public String getCalledBy() {
        if (this.myCalledBy == null) {
            this.myCalledBy = this.getEventList().stream().filter(e -> !e.getEnergyEvent().getCallstack().isEmpty()).map(e -> e.getEnergyEvent().getCallstack().split("\\(", 2)).filter(splitResult -> ((String[])splitResult).length > 0).map(splitResult -> splitResult[0]).findFirst().orElse("");
        }
        return this.myCalledBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnergyDuration duration = (EnergyDuration)o;
        return this.myEventList.equals(duration.myEventList);
    }

    public int hashCode() {
        return Objects.hash(this.myEventList);
    }

    public static enum Kind {
        UNKNOWN("N/A"),
        WAKE_LOCK("Wake Lock"),
        ALARM("Alarm"),
        JOB("Job"),
        LOCATION("Location");

        @NotNull
        private final String myDisplayName;

        @NotNull
        public static Kind from(@NotNull Energy.EnergyEventData event) {
            switch (event.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: 
                case WAKE_LOCK_RELEASED: {
                    return WAKE_LOCK;
                }
                case ALARM_SET: 
                case ALARM_FIRED: 
                case ALARM_CANCELLED: {
                    return ALARM;
                }
                case JOB_SCHEDULED: 
                case JOB_STARTED: 
                case JOB_STOPPED: 
                case JOB_FINISHED: {
                    return JOB;
                }
                case LOCATION_UPDATE_REQUESTED: 
                case LOCATION_UPDATE_REMOVED: 
                case LOCATION_CHANGED: {
                    return LOCATION;
                }
            }
            EnergyDuration.getLogger().warn("Unsupported Kind for " + event.getMetadataCase().name());
            return UNKNOWN;
        }

        private Kind(String displayName) {
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }
    }
}

