/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.trackgroup.TrackGroupListPanel;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTrackRendererFactory;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.customevent.CustomEventProfilerStage;
import com.android.tools.profilers.customevent.UserCounterAspectModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CustomEventProfilerStageView
extends StageView<CustomEventProfilerStage> {
    @NotNull
    private final TrackGroupListPanel myTrackGroupList = new TrackGroupListPanel((TrackRendererFactory)new ProfilerTrackRendererFactory(this.getProfilersView()));

    public CustomEventProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull CustomEventProfilerStage stage) {
        super(profilersView, stage);
        this.myTrackGroupList.loadTrackGroups(((CustomEventProfilerStage)((Object)this.getStage())).getTrackGroupModels());
        ((CustomEventProfilerStage)((Object)this.getStage())).getTimeline().getViewRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateTrackGroupList);
        stage.getUserCounterAspectModel().addDependency(this).onChange((Enum)UserCounterAspectModel.Aspect.USER_COUNTER, this::reloadTrackGroup);
        this.buildUI(stage.getStudioProfilers());
    }

    @Override
    public JComponent getToolbar() {
        JPanel toolBar = new JPanel(ProfilerLayout.createToolbarLayout());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)toolBar, "West");
        return panel2;
    }

    @VisibleForTesting
    @NotNull
    protected final TrackGroupListPanel getTrackGroupList() {
        return this.myTrackGroupList;
    }

    private void buildUI(StudioProfilers profilers) {
        StreamingTimeline timeline = ((CustomEventProfilerStage)((Object)this.getStage())).getTimeline();
        this.getComponent().add((Component)((Object)new ProfilerScrollbar(timeline, this.getComponent())), "South");
        JPanel container = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit-"));
        JPanel mainPanel = new JPanel((LayoutManager)new TabularLayout("*"));
        mainPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        mainPanel.add((Component)this.myTrackGroupList.getComponent(), new TabularLayout.Constraint(1, 0));
        container.add((Component)new JBScrollPane((Component)mainPanel), new TabularLayout.Constraint(0, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        container.add((Component)timeAxis, new TabularLayout.Constraint(1, 0));
        this.getComponent().add((Component)container, "Center");
    }

    private void updateTrackGroupList() {
        this.myTrackGroupList.getComponent().updateUI();
    }

    private void reloadTrackGroup() {
        this.myTrackGroupList.loadTrackGroups(((CustomEventProfilerStage)((Object)this.getStage())).getTrackGroupModels());
        this.updateTrackGroupList();
    }
}

