/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class SliceStream {
    @NotNull
    private final List<TraceEventModel> mySlices;
    private Pattern myPattern = Pattern.compile(".*");
    private Range myRange = new Range(Double.MIN_VALUE, Double.MAX_VALUE);

    public SliceStream(@NotNull List<TraceEventModel> slices) {
        this.mySlices = slices;
    }

    public SliceStream matchPattern(@NotNull Pattern pattern) {
        this.myPattern = pattern;
        return this;
    }

    public SliceStream matchName(@NotNull String name) {
        return this.matchPattern(Pattern.compile("^" + Pattern.quote(name) + ""));
    }

    public SliceStream overlapsRange(Range range) {
        this.myRange = range;
        return this;
    }

    public void enumerate(@NotNull Function<TraceEventModel, EnumerationResult> action) {
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, action);
    }

    public TraceEventModel findFirst() {
        TraceEventModel[] events = new TraceEventModel[1];
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, sliceGroup -> {
            events[0] = sliceGroup;
            return EnumerationResult.TERMINATE;
        });
        return events[0];
    }

    private static EnumerationResult forEachMatchingSlice(@NotNull List<TraceEventModel> eventGroups, @NotNull Pattern pattern, @NotNull Range range, Function<TraceEventModel, EnumerationResult> action) {
        for (TraceEventModel event : eventGroups) {
            EnumerationResult result;
            if (!((double)event.getStartTimestampUs() <= range.getMax()) || !((double)event.getEndTimestampUs() >= range.getMin())) continue;
            boolean skipChildren = false;
            if (pattern.matcher(event.getName()).matches()) {
                EnumerationResult continueResult = action.apply(event);
                if (continueResult == EnumerationResult.TERMINATE) {
                    return continueResult;
                }
                boolean bl = skipChildren = continueResult == EnumerationResult.SKIP_CHILDREN;
            }
            if (skipChildren || (result = SliceStream.forEachMatchingSlice(event.getChildrenEvents(), pattern, range, action)) != EnumerationResult.TERMINATE) continue;
            return result;
        }
        return EnumerationResult.CONTINUE;
    }

    public static enum EnumerationResult {
        CONTINUE,
        TERMINATE,
        SKIP_CHILDREN;

    }
}

