/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuKernelTooltip
extends AspectModel<Aspect>
implements TooltipModel {
    @NotNull
    private final Timeline myTimeline;
    @Nullable
    private DataSeries<CpuThreadSliceInfo> mySeries;
    @Nullable
    private CpuThreadSliceInfo myCpuThreadSliceInfo;
    private int myCpuId;
    private final int myProcessId;

    public CpuKernelTooltip(@NotNull Timeline timeline, int pid) {
        this.myTimeline = timeline;
        this.myProcessId = pid;
        timeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateState);
    }

    public void dispose() {
        this.myTimeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private void updateState() {
        this.myCpuThreadSliceInfo = null;
        if (this.mySeries == null) {
            this.changed(Aspect.CPU_KERNEL_THREAD_SLICE_INFO);
            return;
        }
        Range tooltipRange = this.myTimeline.getTooltipRange();
        List series = this.mySeries.getDataForRange(tooltipRange);
        CpuThreadSliceInfo cpuThreadSliceInfo = this.myCpuThreadSliceInfo = series.isEmpty() ? null : (CpuThreadSliceInfo)((SeriesData)series.get((int)0)).value;
        if (this.myCpuThreadSliceInfo == CpuThreadSliceInfo.NULL_THREAD) {
            this.myCpuThreadSliceInfo = null;
        }
        this.changed(Aspect.CPU_KERNEL_THREAD_SLICE_INFO);
    }

    public void setCpuSeries(int cpuId, @Nullable DataSeries<CpuThreadSliceInfo> stateSeries) {
        this.mySeries = stateSeries;
        this.myCpuId = cpuId;
        this.updateState();
    }

    @Nullable
    public CpuThreadSliceInfo getCpuThreadSliceInfo() {
        return this.myCpuThreadSliceInfo;
    }

    public int getCpuId() {
        return this.myCpuId;
    }

    public int getProcessId() {
        return this.myProcessId;
    }

    @NotNull
    public Timeline getTimeline() {
        return this.myTimeline;
    }

    public static enum Aspect {
        CPU_KERNEL_THREAD_SLICE_INFO;

    }
}

