/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SimpleperfSampleReporter
implements TracePreProcessor {
    private static Logger getLogger() {
        return Logger.getInstance(SimpleperfSampleReporter.class);
    }

    @Override
    @NotNull
    public ByteString preProcessTrace(@NotNull ByteString trace, @NotNull List<String> symbolDirs) {
        try {
            boolean reportSampleSuccess;
            File processedTraceFile = FileUtil.createTempFile((String)String.format("%s%ctrace-%d", FileUtil.getTempDirectory(), Character.valueOf(File.separatorChar), System.currentTimeMillis()), (String)".trace", (boolean)true);
            Process reportSample = new ProcessBuilder(this.getReportSampleCommand(trace, processedTraceFile, symbolDirs)).start();
            reportSample.waitFor();
            boolean bl = reportSampleSuccess = reportSample.exitValue() == 0;
            if (!reportSampleSuccess) {
                String error = new BufferedReader(new InputStreamReader(reportSample.getErrorStream())).readLine();
                SimpleperfSampleReporter.getLogger().warn("simpleperf report-sample exited unsuccessfully. " + error);
                return FAILURE;
            }
            ByteString processedTrace = ByteString.copyFrom((byte[])Files.readAllBytes(processedTraceFile.toPath()));
            processedTraceFile.delete();
            return processedTrace;
        }
        catch (IOException e) {
            SimpleperfSampleReporter.getLogger().warn(String.format("I/O error when trying to execute simpleperf report-sample:\n%s", e.getMessage()));
            return FAILURE;
        }
        catch (InterruptedException e) {
            SimpleperfSampleReporter.getLogger().warn(String.format("Failed to wait for simpleperf report-sample command to run:\n%s", e.getMessage()));
            return FAILURE;
        }
    }

    @VisibleForTesting
    List<String> getReportSampleCommand(@NotNull ByteString trace, @NotNull File processedTrace, @NotNull List<String> symbolDirs) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getSimpleperfBinaryPath());
        command.add("report-sample");
        command.add("--protobuf");
        command.add("--show-callchain");
        command.add("-i");
        command.add(SimpleperfSampleReporter.tempFileFromByteString(trace).getAbsolutePath());
        command.add("-o");
        command.add(processedTrace.getAbsolutePath());
        for (String path : symbolDirs) {
            command.add("--symdir");
            command.add(path);
        }
        return command;
    }

    @VisibleForTesting
    String getSimpleperfBinaryPath() {
        String subDir = SimpleperfSampleReporter.getSimpleperfBinarySubdirectory();
        String binaryName = SimpleperfSampleReporter.getSimpleperfBinaryName();
        if (StudioPathManager.isRunningFromSources()) {
            return Paths.get(StudioPathManager.getSourcesRoot(), "prebuilts", "tools", subDir, "simpleperf", binaryName).toString();
        }
        return Paths.get(PathManager.getHomePath(), "plugins", "android", "resources", "simpleperf", subDir, binaryName).toString();
    }

    private static File tempFileFromByteString(@NotNull ByteString bytes) throws IOException {
        File file = FileUtil.createTempFile((String)String.format("cpu_trace_%d", System.currentTimeMillis()), (String)".trace", (boolean)true);
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(bytes.toByteArray());
        }
        return file;
    }

    private static String getSimpleperfBinarySubdirectory() {
        String os;
        if (SystemInfo.isLinux) {
            os = "linux-x86";
        } else if (SystemInfo.isMac) {
            os = "darwin-x86";
        } else if (SystemInfo.isWindows) {
            os = "windows";
        } else {
            throw new IllegalStateException("Unknown operating system");
        }
        String suffix64bit = SystemInfo.is64Bit ? (SystemInfo.isWindows ? "-x86_64" : "_64") : "";
        return String.format("%s%s", os, suffix64bit);
    }

    private static String getSimpleperfBinaryName() {
        return SystemInfo.isWindows ? "simpleperf.exe" : "simpleperf";
    }
}

