/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.config;

import com.android.tools.adtui.stdui.menu.CommonSeparatorUI;
import com.android.tools.adtui.util.SwingUtil;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.ProfilerComboboxCellRenderer;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.SeparatorUI;
import org.jetbrains.annotations.NotNull;

public class CpuProfilingConfigurationView {
    static final ProfilingConfiguration EDIT_CONFIGURATIONS_ENTRY = new UnspecifiedConfiguration("Edit Configurations...");
    static final ProfilingConfiguration CONFIG_SEPARATOR_ENTRY = new UnspecifiedConfiguration("Configuration Separator Entry");
    private final ProfilingConfiguration API_INITIATED_TRACING_PROFILING_CONFIG = new ArtInstrumentedConfiguration("Debug API (Java)");
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    @NotNull
    private final JComboBox<ProfilingConfiguration> myComboBox;

    public CpuProfilingConfigurationView(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        this.myStage = stage;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myComboBox = new ProfilerCombobox<ProfilingConfiguration>(new DefaultComboBoxModel<ProfilingConfiguration>(){

            @Override
            public void setSelectedItem(Object item) {
                if (item == CONFIG_SEPARATOR_ENTRY) {
                    return;
                }
                super.setSelectedItem(item);
            }
        });
        this.configureProfilingConfigCombo();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComboBox;
    }

    @VisibleForTesting
    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        if (this.myStage.isApiInitiatedTracingInProgress()) {
            return this.API_INITIATED_TRACING_PROFILING_CONFIG;
        }
        return this.myStage.getProfilerConfigModel().getProfilingConfiguration();
    }

    @VisibleForTesting
    void setProfilingConfiguration(@NotNull ProfilingConfiguration mode) {
        if (mode == EDIT_CONFIGURATIONS_ENTRY) {
            this.openProfilingConfigurationsDialog();
        } else if (mode != CONFIG_SEPARATOR_ENTRY) {
            this.myStage.getProfilerConfigModel().setProfilingConfiguration(mode);
        }
    }

    @VisibleForTesting
    void openProfilingConfigurationsDialog() {
        Consumer<ProfilingConfiguration> dialogCallback = configuration -> {
            this.myStage.getProfilerConfigModel().updateProfilingConfigurations();
            if (configuration != null) {
                this.setProfilingConfiguration((ProfilingConfiguration)configuration);
            }
        };
        Common.Device selectedDevice = this.myStage.getStudioProfilers().getDevice();
        int deviceFeatureLevel = selectedDevice != null ? selectedDevice.getFeatureLevel() : 0;
        this.myIdeProfilerComponents.openCpuProfilingConfigurationsDialog(this.myStage.getProfilerConfigModel(), deviceFeatureLevel, dialogCallback);
        this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackOpenProfilingConfigDialog();
    }

    @NotNull
    @VisibleForTesting
    List<ProfilingConfiguration> getProfilingConfigurations() {
        ArrayList<ProfilingConfiguration> configs = new ArrayList<ProfilingConfiguration>();
        if (this.myStage.isApiInitiatedTracingInProgress()) {
            configs.add(this.API_INITIATED_TRACING_PROFILING_CONFIG);
            return configs;
        }
        configs.add(EDIT_CONFIGURATIONS_ENTRY);
        List<ProfilingConfiguration> customEntries = this.myStage.getProfilerConfigModel().getCustomProfilingConfigurationsDeviceFiltered();
        if (!customEntries.isEmpty()) {
            configs.add(CONFIG_SEPARATOR_ENTRY);
            configs.addAll(customEntries);
        }
        configs.add(CONFIG_SEPARATOR_ENTRY);
        configs.addAll(this.myStage.getProfilerConfigModel().getDefaultProfilingConfigurations());
        return configs;
    }

    private void configureProfilingConfigCombo() {
        JComboBoxView<ProfilingConfiguration, CpuProfilerAspect> profilingConfiguration = new JComboBoxView<ProfilingConfiguration, CpuProfilerAspect>(this.myComboBox, this.myStage.getAspect(), CpuProfilerAspect.PROFILING_CONFIGURATION, this::getProfilingConfigurations, this::getProfilingConfiguration, this::setProfilingConfiguration);
        profilingConfiguration.bind();
        SwingUtil.doNotSelectItems(this.myComboBox, e -> e == CONFIG_SEPARATOR_ENTRY);
        this.myComboBox.setRenderer((ListCellRenderer<ProfilingConfiguration>)((Object)new ProfilingConfigurationRenderer()));
    }

    private static class ProfilingConfigurationRenderer
    extends ProfilerComboboxCellRenderer<ProfilingConfiguration> {
        private ProfilingConfigurationRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            if (value == CONFIG_SEPARATOR_ENTRY) {
                JSeparator separator = new JSeparator();
                separator.setUI((SeparatorUI)new CommonSeparatorUI());
                return separator;
            }
            return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            this.append(value.getName());
        }
    }
}

