/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.DataVisualizationColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.NativeNodeModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class NativeModelHChartColors {
    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (!(model instanceof NativeNodeModel)) {
            throw new IllegalStateException("Model must be a subclass of NativeNodeModel.");
        }
    }

    private static boolean isUserFunction(CaptureNodeModel model) {
        if (!(model instanceof CppFunctionModel)) {
            return false;
        }
        return ((CppFunctionModel)model).isUserCode();
    }

    private static boolean isPlatformFunction(CaptureNodeModel method) {
        return method.getFullName().startsWith("art::") || method.getFullName().startsWith("android::") || method.getFullName().startsWith("art_") || method.getFullName().startsWith("dalvik-jit-code-cache");
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        NativeModelHChartColors.validateModel(model);
        Object color = chartType == CaptureDetails.Type.CALL_CHART ? (isDeselected ? DataVisualizationColors.INSTANCE.getColor("Gray", isFocused) : (NativeModelHChartColors.isUserFunction(model) ? (isFocused ? ProfilerColors.CPU_CALLCHART_APP_HOVER : ProfilerColors.CPU_CALLCHART_APP) : (NativeModelHChartColors.isPlatformFunction(model) ? (isFocused ? ProfilerColors.CPU_CALLCHART_PLATFORM_HOVER : ProfilerColors.CPU_CALLCHART_PLATFORM) : (isFocused ? ProfilerColors.CPU_CALLCHART_VENDOR_HOVER : ProfilerColors.CPU_CALLCHART_VENDOR)))) : (NativeModelHChartColors.isUserFunction(model) ? (isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER : ProfilerColors.CPU_FLAMECHART_APP) : (NativeModelHChartColors.isPlatformFunction(model) ? (isFocused ? ProfilerColors.CPU_FLAMECHART_PLATFORM_HOVER : ProfilerColors.CPU_FLAMECHART_PLATFORM) : (isFocused ? ProfilerColors.CPU_FLAMECHART_VENDOR_HOVER : ProfilerColors.CPU_FLAMECHART_VENDOR)));
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor((Color)color) : color;
    }
}

