/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CpuTreeNode<T extends CpuTreeNode> {
    protected final List<CaptureNode> myNodes = new ArrayList<CaptureNode>();
    private final List<T> myChildren = new ArrayList<T>();
    private final String myId;
    protected double myGlobalTotal = 0.0;
    protected double myGlobalChildrenTotal = 0.0;
    protected double myThreadTotal = 0.0;
    protected double myThreadChildrenTotal = 0.0;

    public CpuTreeNode(String id) {
        this.myId = id;
    }

    public String getId() {
        return this.myId;
    }

    protected void addNode(@NotNull CaptureNode node) {
        this.myNodes.add(node);
    }

    protected void addNodes(@NotNull List<CaptureNode> nodes) {
        nodes.forEach(this::addNode);
    }

    @NotNull
    public List<CaptureNode> getNodes() {
        return this.myNodes;
    }

    protected void addChild(@NotNull T child) {
        this.myChildren.add(child);
    }

    public List<T> getChildren() {
        return this.myChildren;
    }

    public double getGlobalTotal() {
        return this.myGlobalTotal;
    }

    public double getThreadTotal() {
        return this.myThreadTotal;
    }

    public double getGlobalChildrenTotal() {
        return this.myGlobalChildrenTotal;
    }

    public double getSelf() {
        return this.getGlobalTotal() - this.getGlobalChildrenTotal();
    }

    public void update(@NotNull Range range) {
        this.myGlobalTotal = 0.0;
        this.myGlobalChildrenTotal = 0.0;
        this.myThreadTotal = 0.0;
        this.myThreadChildrenTotal = 0.0;
        for (CaptureNode node : this.myNodes) {
            this.myGlobalTotal += CpuTreeNode.getIntersection(range, node, ClockType.GLOBAL);
            this.myThreadTotal += CpuTreeNode.getIntersection(range, node, ClockType.THREAD);
            for (CaptureNode child : node.getChildren()) {
                this.myGlobalChildrenTotal += CpuTreeNode.getIntersection(range, child, ClockType.GLOBAL);
                this.myThreadChildrenTotal += CpuTreeNode.getIntersection(range, child, ClockType.THREAD);
            }
        }
    }

    protected static double getIntersection(@NotNull Range range, @NotNull CaptureNode node, @NotNull ClockType type) {
        return type == ClockType.GLOBAL ? range.getIntersectionLength((double)node.getStartGlobal(), (double)node.getEndGlobal()) : range.getIntersectionLength((double)node.getStartThread(), (double)node.getEndThread());
    }

    public boolean inRange(Range range) {
        return this.myNodes.stream().anyMatch(node -> (double)node.getStart() < range.getMax() && range.getMin() < (double)node.getEnd());
    }

    public void reset() {
        this.myGlobalTotal = 0.0;
        this.myGlobalChildrenTotal = 0.0;
        this.myThreadTotal = 0.0;
        this.myThreadChildrenTotal = 0.0;
    }

    @NotNull
    public abstract CaptureNodeModel getMethodModel();

    public abstract CaptureNode.FilterType getFilterType();

    public boolean isUnmatched() {
        return this.getFilterType() == CaptureNode.FilterType.UNMATCH;
    }
}

