/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.TabbedToolbar;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChart;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisEventsTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.FullTraceAnalysisSummaryTabModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisPanel
extends AspectObserver {
    private final TabbedToolbar myTabs;
    private final JBTabbedPane myTabView = new JBTabbedPane();
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final CpuCaptureStage myStage;
    private final StudioProfilersView myProfilersView;
    private CpuAnalysisModel mySelectedModel;
    private ViewBinder<StudioProfilersView, CpuAnalysisTabModel, CpuAnalysisTab> myTabViewsBinder;

    public CpuAnalysisPanel(@NotNull StudioProfilersView view, @NotNull CpuCaptureStage stage) {
        this.myStage = stage;
        this.myProfilersView = view;
        JLabel tabsTitle = new JLabel("Analysis");
        tabsTitle.setBorder(JBUI.Borders.empty((int)5));
        this.myTabs = new TabbedToolbar((JComponent)tabsTitle);
        this.setupBindings();
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuCaptureStage.Aspect.ANALYSIS_MODEL_UPDATED, this::updateComponents);
        this.myTabs.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)1, (int)0));
        this.myPanel.add((Component)this.myTabs, "North");
        this.myPanel.add((Component)this.myTabView, "Center");
        this.myTabView.setTabComponentInsets((Insets)JBUI.insets((int)0));
        this.myTabView.addChangeListener((ChangeListener)new TabChangeListener());
    }

    private void setupBindings() {
        this.myTabViewsBinder = new ViewBinder();
        this.myTabViewsBinder.bind(CpuAnalysisChartModel.class, CpuAnalysisChart::new);
        this.myTabViewsBinder.bind(FullTraceAnalysisSummaryTabModel.class, CpuAnalysisSummaryTab::new);
        this.myTabViewsBinder.bind(CpuThreadAnalysisSummaryTabModel.class, CpuAnalysisSummaryTab::new);
        this.myTabViewsBinder.bind(CaptureNodeAnalysisSummaryTabModel.class, CpuAnalysisSummaryTab::new);
        this.myTabViewsBinder.bind(CpuThreadAnalysisEventsTabModel.class, CpuAnalysisEventsTab::new);
        this.myTabViewsBinder.bind(CaptureNodeAnalysisEventsTabModel.class, CpuAnalysisEventsTab::new);
    }

    @NotNull
    @VisibleForTesting
    JBTabbedPane getTabView() {
        return this.myTabView;
    }

    @NotNull
    @VisibleForTesting
    TabbedToolbar getTabs() {
        return this.myTabs;
    }

    @NotNull
    @VisibleForTesting
    public ViewBinder<StudioProfilersView, CpuAnalysisTabModel, CpuAnalysisTab> getTabViewsBinder() {
        return this.myTabViewsBinder;
    }

    private void updateComponents() {
        this.myTabs.clearTabs();
        List<CpuAnalysisModel> models = this.myStage.getAnalysisModels();
        if (models.isEmpty()) {
            return;
        }
        for (CpuAnalysisModel model : models) {
            this.myTabs.addTab(model.getName(), () -> this.onSelectAnalysis(model));
        }
        this.onSelectAnalysis(models.get(models.size() - 1));
    }

    private void onSelectAnalysis(@NotNull CpuAnalysisModel<?> model) {
        this.mySelectedModel = model;
        this.myTabView.removeAll();
        model.getTabModels().forEach(tabModel -> {
            String typeName = tabModel.getTabType().getName();
            this.myTabView.insertTab(typeName, null, (Component)new JPanel(), typeName, this.myTabView.getTabCount());
        });
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private class TabChangeListener
    implements ChangeListener {
        private int myLastSelectedIndex = -1;

        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int newIndex = CpuAnalysisPanel.this.myTabView.getSelectedIndex();
            if (newIndex == this.myLastSelectedIndex || CpuAnalysisPanel.this.mySelectedModel == null) {
                return;
            }
            if (this.myLastSelectedIndex >= 0 && this.myLastSelectedIndex < CpuAnalysisPanel.this.myTabView.getTabCount()) {
                CpuAnalysisPanel.this.myTabView.setComponentAt(this.myLastSelectedIndex, (Component)new JPanel());
            }
            if (newIndex >= 0 && newIndex < CpuAnalysisPanel.this.myTabView.getTabCount()) {
                CpuAnalysisPanel.this.myTabView.setComponentAt(newIndex, (Component)CpuAnalysisPanel.this.myTabViewsBinder.build((Object)CpuAnalysisPanel.this.myProfilersView, CpuAnalysisPanel.this.mySelectedModel.getTabModelAt(newIndex)));
            }
            this.myLastSelectedIndex = newIndex;
        }
    }
}

