/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.PercentAxisFormatter;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisChartModel<T>
extends CpuAnalysisTabModel<T> {
    private static final Map<CpuAnalysisTabModel.Type, CaptureDetails.Type> TAB_TYPE_TO_DETAIL_TYPE = ImmutableMap.of((Object)((Object)CpuAnalysisTabModel.Type.FLAME_CHART), (Object)((Object)CaptureDetails.Type.FLAME_CHART), (Object)((Object)CpuAnalysisTabModel.Type.TOP_DOWN), (Object)((Object)CaptureDetails.Type.TOP_DOWN), (Object)((Object)CpuAnalysisTabModel.Type.BOTTOM_UP), (Object)((Object)CaptureDetails.Type.BOTTOM_UP));
    private final CpuCapture myCapture;
    private final Range mySelectionRange;
    private final CaptureDetails.Type myDetailsType;
    private final AxisComponentModel myAxisComponentModel;
    private final Function<T, Collection<CaptureNode>> myCaptureNodesExtractor;
    @NotNull
    private final Range myClampedSelectionRange;
    @NotNull
    private final Range myCaptureConvertedRange;
    @NotNull
    private final AspectObserver myObserver = new AspectObserver();
    @NotNull
    private final AspectModel<Aspect> myAspectModel = new AspectModel();
    @NotNull
    private ClockType myClockType;

    public CpuAnalysisChartModel(@NotNull CpuAnalysisTabModel.Type tabType, @NotNull Range selectionRange, @NotNull CpuCapture capture, @NotNull Function<T, Collection<CaptureNode>> captureNodesExtractor) {
        super(tabType);
        assert (TAB_TYPE_TO_DETAIL_TYPE.containsKey((Object)tabType));
        this.myCapture = capture;
        this.mySelectionRange = selectionRange;
        this.myClampedSelectionRange = new Range(selectionRange);
        this.myCaptureConvertedRange = new Range();
        selectionRange.addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeSync);
        this.myClampedSelectionRange.addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::updateCaptureConvertedRange);
        this.myCaptureConvertedRange.addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::updateSelectionRange);
        this.myDetailsType = TAB_TYPE_TO_DETAIL_TYPE.get((Object)tabType);
        this.myCaptureNodesExtractor = captureNodesExtractor;
        this.myAxisComponentModel = new ClampedAxisComponentModel.Builder(this.myClampedSelectionRange, (BaseAxisFormatter)new PercentAxisFormatter(5, 10)).build();
        this.setClockType(ClockType.GLOBAL);
    }

    private void selectionRangeSync() {
        this.myClampedSelectionRange.set(this.mySelectionRange);
    }

    @NotNull
    public CaptureDetails createDetails() {
        return this.applyFilterAndCreateDetails(Filter.EMPTY_FILTER).getCaptureDetails();
    }

    @NotNull
    public CaptureDetailsWithFilterResult applyFilterAndCreateDetails(@NotNull Filter filter) {
        List<CaptureNode> nodes = this.collectCaptureNodes();
        FilterResult combinedResult = nodes.stream().map(node -> node.applyFilter(filter)).reduce(FilterResult::combine).orElse(FilterResult.EMPTY_RESULT);
        return new CaptureDetailsWithFilterResult(this.myDetailsType.build(this.myCaptureConvertedRange, nodes, this.myCapture), combinedResult);
    }

    @NotNull
    public CaptureDetails.Type getDetailsType() {
        return this.myDetailsType;
    }

    @NotNull
    public AxisComponentModel getAxisComponentModel() {
        return this.myAxisComponentModel;
    }

    public boolean isCaptureDualClock() {
        return this.myCapture.isDualClock();
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        return ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
    }

    @VisibleForTesting
    public Range getCaptureConvertedRange() {
        return this.myCaptureConvertedRange;
    }

    @NotNull
    public ClockType getClockType() {
        return this.myClockType;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (this.myClockType == clockType || !this.isCaptureDualClock() && clockType == ClockType.THREAD) {
            return;
        }
        this.myClockType = clockType;
        this.myCapture.updateClockType(clockType);
        this.updateCaptureConvertedRange();
        this.myAspectModel.changed((Enum)Aspect.CLOCK_TYPE);
    }

    @NotNull
    public AspectModel<Aspect> getAspectModel() {
        return this.myAspectModel;
    }

    private void updateCaptureConvertedRange() {
        Range selection2 = this.myClampedSelectionRange;
        ClockType clockType = this.getClockType();
        if (clockType == ClockType.GLOBAL || this.getDataSeries().isEmpty()) {
            this.setConvertedRange(selection2);
            return;
        }
        CaptureNode node = this.myCaptureNodesExtractor.apply(this.getDataSeries().get(0)).iterator().next();
        double convertedMin = (double)node.getStartThread() + node.threadGlobalRatio() * (selection2.getMin() - (double)node.getStartGlobal());
        double convertedMax = convertedMin + node.threadGlobalRatio() * selection2.getLength();
        this.setConvertedRange(new Range(convertedMin, convertedMax));
    }

    private void updateSelectionRange() {
        ClockType clockType = this.getClockType();
        if (clockType == ClockType.GLOBAL || this.getDataSeries().isEmpty()) {
            this.setSelectionRange(this.myCaptureConvertedRange);
            return;
        }
        CaptureNode node = this.myCaptureNodesExtractor.apply(this.getDataSeries().get(0)).iterator().next();
        double threadToGlobal = 1.0 / node.threadGlobalRatio();
        double convertedMin = (double)node.getStartGlobal() + threadToGlobal * (this.myCaptureConvertedRange.getMin() - (double)node.getStartThread());
        double convertedMax = convertedMin + threadToGlobal * this.myCaptureConvertedRange.getLength();
        this.setSelectionRange(new Range(convertedMin, convertedMax));
    }

    private void setSelectionRange(Range range) {
        if (!this.myClampedSelectionRange.isSameAs(range)) {
            this.myClampedSelectionRange.set(range);
        }
    }

    private void setConvertedRange(Range range) {
        if (!this.myCaptureConvertedRange.isSameAs(range)) {
            this.myCaptureConvertedRange.set(range);
        }
    }

    @NotNull
    private List<CaptureNode> collectCaptureNodes() {
        return this.getDataSeries().stream().map(this.myCaptureNodesExtractor).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static class CaptureDetailsWithFilterResult {
        @NotNull
        private final CaptureDetails myCaptureDetails;
        @NotNull
        private final FilterResult myFilterResult;

        private CaptureDetailsWithFilterResult(@NotNull CaptureDetails captureDetails, @NotNull FilterResult filterResult) {
            this.myCaptureDetails = captureDetails;
            this.myFilterResult = filterResult;
        }

        @NotNull
        CaptureDetails getCaptureDetails() {
            return this.myCaptureDetails;
        }

        @NotNull
        FilterResult getFilterResult() {
            return this.myFilterResult;
        }
    }

    public static enum Aspect {
        CLOCK_TYPE;

    }
}

