/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.ThreadState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyCpuThreadStateDataSeries
implements DataSeries<ThreadState> {
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;
    private final int myThreadId;
    @Nullable
    private final CpuCapture mySelectedCapture;

    public LegacyCpuThreadStateDataSeries(@NotNull CpuServiceGrpc.CpuServiceBlockingStub client, @NotNull Common.Session session, int tid, @Nullable CpuCapture selectedCapture) {
        this.myClient = client;
        this.mySession = session;
        this.myThreadId = tid;
        this.mySelectedCapture = selectedCapture;
    }

    public List<SeriesData<ThreadState>> getDataForRange(Range range) {
        ArrayList<SeriesData<ThreadState>> data = new ArrayList<SeriesData<ThreadState>>();
        long min = TimeUnit.MICROSECONDS.toNanos((long)range.getMin());
        long max = TimeUnit.MICROSECONDS.toNanos((long)range.getMax());
        CpuProfiler.GetThreadsResponse threads = this.myClient.getThreads(CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(min).setEndTimestamp(max).build());
        for (CpuProfiler.GetThreadsResponse.Thread thread2 : threads.getThreadsList()) {
            if (thread2.getTid() != this.myThreadId) continue;
            ArrayList<Double> captureTimes = new ArrayList<Double>(2);
            if (this.mySelectedCapture != null && this.mySelectedCapture.containsThread(this.myThreadId)) {
                captureTimes.add(this.mySelectedCapture.getRange().getMin());
                captureTimes.add(this.mySelectedCapture.getRange().getMax());
            }
            List list = thread2.getActivitiesList();
            int i2 = 0;
            int j = 0;
            boolean inCapture = false;
            Cpu.CpuThreadData.State state = Cpu.CpuThreadData.State.UNSPECIFIED;
            while (i2 < list.size()) {
                long time;
                long captureTime;
                CpuProfiler.GetThreadsResponse.ThreadActivity activity = (CpuProfiler.GetThreadsResponse.ThreadActivity)list.get(i2);
                long timestamp = TimeUnit.NANOSECONDS.toMicros(activity.getTimestamp());
                long l = captureTime = j < captureTimes.size() ? ((Double)captureTimes.get(j)).longValue() : Long.MAX_VALUE;
                if (captureTime < timestamp) {
                    inCapture = !inCapture;
                    time = captureTime;
                    ++j;
                } else {
                    state = activity.getNewState();
                    time = timestamp;
                    ++i2;
                }
                if (state == Cpu.CpuThreadData.State.UNSPECIFIED) continue;
                data.add((SeriesData<ThreadState>)new SeriesData(time, (Object)CpuThreadsModel.getState(state, inCapture)));
            }
            while (j < captureTimes.size()) {
                inCapture = !inCapture;
                data.add((SeriesData<ThreadState>)new SeriesData(((Double)captureTimes.get(j)).longValue(), (Object)CpuThreadsModel.getState(state, inCapture)));
                ++j;
            }
        }
        return data;
    }
}

