/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.trackgroup.SelectableTrackModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltip;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadTrackModel
implements CpuAnalyzable<CpuThreadTrackModel> {
    @NotNull
    private final StateChartModel<ThreadState> myThreadStateChartModel = new StateChartModel();
    @NotNull
    private final CaptureDetails.CallChart myCallChartModel;
    @NotNull
    private final CpuCapture myCapture;
    @NotNull
    private final Timeline myTimeline;
    @NotNull
    private final CpuThreadInfo myThreadInfo;
    @NotNull
    private final CpuThreadsTooltip myThreadStateTooltip;
    @NotNull
    private final Function<CaptureNode, CpuCaptureNodeTooltip> myTraceEventTooltipBuilder;
    @NotNull
    private final MultiSelectionModel<CpuAnalyzable> myMultiSelectionModel;
    @Nullable
    private final DataSeries<ThreadState> myThreadStateSeries;

    public CpuThreadTrackModel(@NotNull CpuCapture capture, @NotNull CpuThreadInfo threadInfo, @NotNull Timeline timeline, @NotNull MultiSelectionModel<CpuAnalyzable> multiSelectionModel) {
        this.myThreadStateTooltip = new CpuThreadsTooltip(timeline);
        this.myCallChartModel = new CaptureDetails.CallChart(timeline.getViewRange(), Collections.singletonList(capture.getCaptureNode(threadInfo.getId())), capture);
        this.myCapture = capture;
        this.myThreadInfo = threadInfo;
        this.myTimeline = timeline;
        this.myMultiSelectionModel = multiSelectionModel;
        if (capture.getSystemTraceData() != null) {
            this.myThreadStateSeries = new LazyDataSeries<ThreadState>(() -> capture.getSystemTraceData().getThreadStatesForThread(threadInfo.getId()));
            this.myThreadStateChartModel.addSeries(new RangedSeries(timeline.getViewRange(), this.myThreadStateSeries));
            this.myThreadStateTooltip.setThread(threadInfo.getName(), this.myThreadStateSeries);
        } else {
            this.myThreadStateSeries = null;
        }
        this.myTraceEventTooltipBuilder = captureNode -> new CpuCaptureNodeTooltip(timeline, (CaptureNode)captureNode);
    }

    @NotNull
    public StateChartModel<ThreadState> getThreadStateChartModel() {
        return this.myThreadStateChartModel;
    }

    @NotNull
    public CaptureDetails.CallChart getCallChartModel() {
        return this.myCallChartModel;
    }

    @NotNull
    public CpuCapture getCapture() {
        return this.myCapture;
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CpuThreadTrackModel> getAnalysisModel() {
        CpuAnalysisModel<CpuThreadTrackModel> model = new CpuAnalysisModel<CpuThreadTrackModel>(this.myThreadInfo.getName(), "%d threads");
        Range selectionRange = this.myTimeline.getSelectionRange().isEmpty() ? this.myTimeline.getViewRange() : this.myTimeline.getSelectionRange();
        CpuThreadAnalysisSummaryTabModel summary = new CpuThreadAnalysisSummaryTabModel(this.myCapture.getRange(), selectionRange);
        summary.getDataSeries().add(this);
        model.addTabModel(summary);
        CpuAnalysisChartModel<CpuThreadTrackModel> flameChart = new CpuAnalysisChartModel<CpuThreadTrackModel>(CpuAnalysisTabModel.Type.FLAME_CHART, selectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode);
        flameChart.getDataSeries().add(this);
        model.addTabModel(flameChart);
        CpuAnalysisChartModel<CpuThreadTrackModel> topDown = new CpuAnalysisChartModel<CpuThreadTrackModel>(CpuAnalysisTabModel.Type.TOP_DOWN, selectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode);
        topDown.getDataSeries().add(this);
        model.addTabModel(topDown);
        CpuAnalysisChartModel<CpuThreadTrackModel> bottomUp = new CpuAnalysisChartModel<CpuThreadTrackModel>(CpuAnalysisTabModel.Type.BOTTOM_UP, selectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode);
        bottomUp.getDataSeries().add(this);
        model.addTabModel(bottomUp);
        CpuThreadAnalysisEventsTabModel events = new CpuThreadAnalysisEventsTabModel(this.myCapture.getRange());
        events.getDataSeries().add(this);
        model.addTabModel(events);
        return model;
    }

    public boolean isCompatibleWith(@NotNull SelectableTrackModel otherObj) {
        return otherObj instanceof CpuThreadTrackModel;
    }

    @NotNull
    public CpuThreadsTooltip getThreadStateTooltip() {
        return this.myThreadStateTooltip;
    }

    @NotNull
    public Function<CaptureNode, CpuCaptureNodeTooltip> getTraceEventTooltipBuilder() {
        return this.myTraceEventTooltipBuilder;
    }

    @NotNull
    public MultiSelectionModel<CpuAnalyzable> getMultiSelectionModel() {
        return this.myMultiSelectionModel;
    }

    @NotNull
    public CpuThreadInfo getThreadInfo() {
        return this.myThreadInfo;
    }

    @Nullable
    public DataSeries<ThreadState> getThreadStateSeries() {
        return this.myThreadStateSeries;
    }

    private Collection<CaptureNode> getCaptureNode() {
        assert (this.myCapture.containsThread(this.myThreadInfo.getId()));
        return Collections.singleton(this.myCapture.getCaptureNode(this.myThreadInfo.getId()));
    }
}

