/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.TraceIdsIterator;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureModel;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.CpuFramesModel;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelModel;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends StreamingStage
implements CodeNavigator.Listener {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    public static final int CPU_ART_STOP_TIMEOUT_SEC = Math.max(5, Math.min(Integer.getInteger("profiler.cpu.art.stop.timeout.sec", 120), 300));
    static final double IMPORTED_TRACE_VIEW_EXPAND_PERCENTAGE = 0.1;
    private static final CaptureDetails.Type DEFAULT_CAPTURE_DETAILS = CaptureDetails.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final CpuKernelModel myCpuKernelModel;
    private final ClampedAxisComponentModel myCpuUsageAxis;
    private final ClampedAxisComponentModel myThreadCountAxis;
    private final ResizingAxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final RangeSelectionModel myRangeSelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuProfilerConfigModel myProfilerConfigModel;
    private final CpuFramesModel myFramesModel;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect = new AspectModel();
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private long myCaptureStopTimeNs;
    private final InProgressTraceHandler myInProgressTraceHandler;
    @NotNull
    private Cpu.CpuTraceInfo myInProgressTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final TraceIdsIterator myTraceIdsIterator;
    private final boolean myIsImportTraceMode;
    @Nullable
    private final File myImportedTrace;
    @Nullable
    private Cpu.CpuTraceInfo myImportedTraceInfo;
    @NotNull
    private final Common.Session mySession;
    private final Map<Long, CpuTraceInfo> myCompletedTraceIdToInfoMap = new HashMap<Long, CpuTraceInfo>();

    public CpuProfilerStage(@NotNull StudioProfilers profilers) {
        this(profilers, null);
    }

    public CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace) {
        this(profilers, importedTrace, new CpuCaptureParser(profilers.getIdeServices()));
    }

    @VisibleForTesting
    CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace, @NotNull CpuCaptureParser captureParser) {
        super(profilers);
        this.myImportedTrace = importedTrace;
        this.mySession = profilers.getSession();
        this.myIsImportTraceMode = importedTrace != null;
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myProfilerConfigModel = new CpuProfilerConfigModel(profilers, this);
        Range viewRange = this.getTimeline().getViewRange();
        Range dataRange = this.getTimeline().getDataRange();
        Range selectionRange = this.getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER).build();
        this.myThreadCountAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS).build();
        this.myTimeAxisGuide = new ResizingAxisComponentModel.Builder(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS).setGlobalRange(dataRange).build();
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, profilers, this.mySession, this.myIsImportTraceMode);
        this.myCpuKernelModel = new CpuKernelModel(viewRange, this);
        this.myFramesModel = new CpuFramesModel(viewRange, this);
        this.myEventMonitor = new EventMonitor(profilers);
        this.myRangeSelectionModel = this.buildRangeSelectionModel(selectionRange, viewRange);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myCaptureState = CaptureState.IDLE;
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = captureParser;
        List<Cpu.CpuTraceInfo> existingCompletedTraceInfoList = CpuProfiler.getTraceInfoFromSession(this.getStudioProfilers().getClient(), this.mySession, this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()).stream().filter(info -> info.getToTimestamp() != -1L).collect(Collectors.toList());
        existingCompletedTraceInfoList.forEach(info -> this.myCompletedTraceIdToInfoMap.put(info.getTraceId(), new CpuTraceInfo((Cpu.CpuTraceInfo)info)));
        this.myTraceIdsIterator = new TraceIdsIterator(this, existingCompletedTraceInfoList);
        this.myInProgressTraceHandler = new InProgressTraceHandler();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    private RangeSelectionModel buildRangeSelectionModel(@NotNull Range selectionRange, @NotNull Range viewRange) {
        RangeSelectionModel rangeSelectionModel = new RangeSelectionModel(selectionRange, viewRange);
        rangeSelectionModel.addConstraint(this.myTraceDurations);
        if (this.myIsImportTraceMode) {
            rangeSelectionModel.addListener(new RangeSelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                }

                public void selectionCleared() {
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }

                public void selectionCreationFailure() {
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }
            });
        } else {
            rangeSelectionModel.addListener(new RangeSelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCleared() {
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCreationFailure() {
                    CpuProfilerStage.this.selectionChanged();
                }
            });
        }
        return rangeSelectionModel;
    }

    public boolean isImportTraceMode() {
        return this.myIsImportTraceMode;
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        return this.myRangeSelectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public CpuProfilerConfigModel getProfilerConfigModel() {
        return this.myProfilerConfigModel;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        CodeNavigator navigator = this.getStudioProfilers().getIdeServices().getCodeNavigator();
        navigator.addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, this.myProfilerConfigModel::updateProfilingConfigurations);
        this.myProfilerConfigModel.updateProfilingConfigurations();
        if (this.myIsImportTraceMode) {
            assert (this.myImportedTrace != null);
            this.parseAndSelectImportedTrace(this.myImportedTrace, this.mySession.getSessionId());
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuNewRecordingWorkflowEnabled()) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.getStudioProfilers().removeDependencies(this);
        this.myCaptureParser.abortParsing();
        this.myRangeSelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        return this.myUpdatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void toggleCapturing() {
        if (this.myCaptureState == CaptureState.CAPTURING) {
            this.stopCapturing();
        } else {
            this.startCapturing();
        }
    }

    public void startCapturing() {
        ProfilingConfiguration config = this.myProfilerConfigModel.getProfilingConfiguration();
        assert (this.getStudioProfilers().getProcess() != null);
        Common.Process process = this.getStudioProfilers().getProcess();
        String traceFilePath = String.format("%s/%s-%d.trace", "/data/local/tmp/perfd", process.getName(), System.nanoTime());
        if (config.isDisableLiveAllocation()) {
            this.getStudioProfilers().setMemoryLiveAllocationEnabled(false);
        }
        this.setCaptureState(CaptureState.STARTING);
        Cpu.CpuTraceConfiguration configuration = Cpu.CpuTraceConfiguration.newBuilder().setAppName(process.getName()).setAbiCpuArch(process.getAbiCpuArch()).setInitiationType(Cpu.TraceInitiationType.INITIATED_BY_UI).setTempPath(traceFilePath).setUserOptions(config.toProto()).addAllSymbolDirs(this.getStudioProfilers().getIdeServices().getNativeSymbolsDirectories()).build();
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setType(Commands.Command.CommandType.START_CPU_TRACE).setStartCpuTrace(Cpu.StartCpuTrace.newBuilder().setConfiguration(configuration).build()).build();
            Transport.ExecuteResponse response2 = this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(startCommand).build());
            TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.CPU_TRACE_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response2.getCommandId(), () -> this.mySession.getStreamId(), () -> this.mySession.getPid(), event -> {
                this.startCapturingCallback(event.getCpuTraceStatus().getTraceStartStatus());
                return true;
            });
            this.getStudioProfilers().getTransportPoller().registerListener(statusListener);
        } else {
            CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setSession(this.mySession).setConfiguration(configuration).build();
            CompletableFuture.supplyAsync(() -> this.getCpuClient().startProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> this.startCapturingCallback(response.getStatus()), this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void startCapturingCallback(@NotNull Cpu.TraceStartStatus status) {
        if (status.getStatus().equals((Object)Cpu.TraceStartStatus.Status.SUCCESS)) {
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.setCaptureState(CaptureState.CAPTURING);
            this.getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + status.getStatus());
            CpuProfilerStage.getLogger().warn(status.getErrorMessage());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_START_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
        }
    }

    @VisibleForTesting
    void stopCapturing() {
        if (Cpu.CpuTraceInfo.getDefaultInstance().equals((Object)this.myInProgressTraceInfo)) {
            return;
        }
        this.myCaptureStopTimeNs = this.currentTimeNs();
        this.setCaptureState(CaptureState.STOPPING);
        CpuProfiler.stopTracing(this.getStudioProfilers(), this.mySession, this.myInProgressTraceInfo.getConfiguration(), this::stopCapturingCallback);
    }

    public long getCaptureStartTimeNs() {
        return this.myCaptureStartTimeNs;
    }

    public long getCaptureStopTimeNs() {
        return this.myCaptureStopTimeNs;
    }

    @NotNull
    public TraceIdsIterator getTraceIdsIterator() {
        return this.myTraceIdsIterator;
    }

    void navigateNext() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.next());
    }

    void navigatePrevious() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.previous());
    }

    private void handleCaptureNavigation(long traceId) {
        if (traceId == -1L) {
            return;
        }
        this.setAndSelectCapture(traceId);
    }

    private void stopCapturingCallback(@NotNull Cpu.TraceStopStatus status) {
        if (!status.getStatus().equals((Object)Cpu.TraceStopStatus.Status.UNSPECIFIED) && !status.getStatus().equals((Object)Cpu.TraceStopStatus.Status.SUCCESS)) {
            this.trackAndLogTraceStopFailures(status);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
        }
        if (this.myProfilerConfigModel.getProfilingConfiguration().isDisableLiveAllocation()) {
            this.getStudioProfilers().setMemoryLiveAllocationEnabled(true);
        }
    }

    private void trackAndLogTraceStopFailures(@NotNull Cpu.TraceStopStatus status) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerConfigModel.getProfilingConfiguration());
        long estimateDurationMs = TimeUnit.NANOSECONDS.toMillis(this.currentTimeNs() - this.myCaptureStartTimeNs);
        captureMetadata.setCaptureDurationMs(estimateDurationMs);
        captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(status.getStoppingTimeNs()));
        captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.fromStopStatus(status.getStatus()));
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + status.getStatus());
        CpuProfilerStage.getLogger().warn(status.getErrorMessage());
        this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_STOP_FAILURE);
    }

    private void goToCaptureStage(long traceId) {
        CpuCaptureStage stage = CpuCaptureStage.create(this.getStudioProfilers(), this.getProfilerConfigModel().getProfilingConfiguration(), traceId);
        if (stage != null) {
            this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage(stage));
        } else {
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
        }
    }

    @NotNull
    public CpuCaptureParser getCaptureParser() {
        return this.myCaptureParser;
    }

    private void parseAndSelectImportedTrace(@NotNull File traceFile, long traceId) {
        assert (this.myIsImportTraceMode);
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(traceFile, traceId, Cpu.CpuTraceType.UNSPECIFIED_TYPE, 0, "");
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            if (parsedCapture != null) {
                EventStreamServer streamServer;
                StreamingTimeline timeline = this.getTimeline();
                Range captureRangeNs = new Range((double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMin()), (double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMax()));
                double expandAmountNs = 0.1 * captureRangeNs.getLength();
                timeline.reset((long)captureRangeNs.getMin(), (long)(captureRangeNs.getMax() + expandAmountNs));
                timeline.setIsPaused(true);
                this.myImportedTraceInfo = Cpu.CpuTraceInfo.newBuilder().setTraceId(traceId).setFromTimestamp((long)captureRangeNs.getMin()).setToTimestamp((long)captureRangeNs.getMax()).setConfiguration(Cpu.CpuTraceConfiguration.newBuilder().setUserOptions(Cpu.CpuTraceConfiguration.UserOptions.newBuilder().setTraceType(parsedCapture.getType()))).build();
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                double expandAmountUs = TimeUnit.NANOSECONDS.toMicros((long)expandAmountNs);
                timeline.getViewRange().set(parsedCapture.getRange().getMin() - expandAmountUs, parsedCapture.getRange().getMax() + expandAmountUs);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled() && (streamServer = this.getStudioProfilers().getSessionsManager().getEventStreamServer(this.mySession.getStreamId())) != null) {
                    streamServer.getEventDeque().offer(Common.Event.newBuilder().setGroupId(this.myImportedTraceInfo.getTraceId()).setTimestamp((long)captureRangeNs.getMax()).setIsEnded(true).setKind(Common.Event.Kind.CPU_TRACE).setCpuTrace(Cpu.CpuTraceData.newBuilder().setTraceEnded(Cpu.CpuTraceData.TraceEnded.newBuilder().setTraceInfo(this.myImportedTraceInfo))).build());
                }
            } else if (capture.isCancelled()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_ABORTED);
            } else {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
                this.setCaptureState(CaptureState.IDLE);
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackImportTrace(Cpu.CpuTraceType.UNSPECIFIED_TYPE, false);
            }
        };
        capture.handleAsync((parsedCapture, exception) -> {
            parsingCallback.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
        return this.getStudioProfilers().getClient().getCpuClient();
    }

    private void selectionChanged() {
        CpuTraceInfo intersectingTraceInfo = this.getIntersectingTraceInfo(this.getTimeline().getSelectionRange());
        if (intersectingTraceInfo == null) {
            this.setCapture(null);
        } else {
            this.setCapture(intersectingTraceInfo.getTraceId());
        }
    }

    @Nullable
    CpuTraceInfo getIntersectingTraceInfo(Range range) {
        List infoList = this.getTraceDurations().getSeries().getSeriesForRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (!captureRange.intersectsWith(range)) continue;
            return (CpuTraceInfo)info.value;
        }
        return null;
    }

    public long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getTimeline().getDataRange().getMax());
    }

    @VisibleForTesting
    public void setCapture(@Nullable CpuCapture capture) {
        if (!this.myCaptureModel.setCapture(capture)) {
            return;
        }
        if (capture != null) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
            this.onCaptureSelection();
        }
    }

    private void onCaptureSelection() {
        CpuCapture capture = this.getCapture();
        if (capture == null) {
            return;
        }
        if (this.getCaptureState() == CaptureState.IDLE || this.getCaptureState() == CaptureState.CAPTURING) {
            this.ensureCaptureInViewRange();
            if (capture.getSystemTraceData() != null && !this.isImportTraceMode() && capture.getSystemTraceData().isMissingData()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.ATRACE_BUFFER_OVERFLOW);
            }
        }
    }

    private void ensureCaptureInViewRange() {
        CpuCapture capture = this.getCapture();
        assert (capture != null);
        double padding = this.getTimeline().getViewRange().getLength() * 0.05;
        this.getTimeline().adjustRangeCloseToMiddleView(new Range(capture.getRange().getMin() - padding, capture.getRange().getMax() + padding));
    }

    private void setCapture(long traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.myInProgressTraceInfo.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance()) ? CaptureState.IDLE : CaptureState.CAPTURING);
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(long traceId) {
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
            this.goToCaptureStage(traceId);
        } else {
            CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
            if (future == null) {
                this.setCaptureState(this.myInProgressTraceInfo.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance()) ? CaptureState.IDLE : CaptureState.CAPTURING);
            } else {
                future.handleAsync((capture, exception) -> {
                    this.setCaptureState(this.myInProgressTraceInfo.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance()) ? CaptureState.IDLE : CaptureState.CAPTURING);
                    if (capture != null) {
                        this.setAndSelectCapture((CpuCapture)capture);
                        this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                    }
                    return capture;
                }, this.getStudioProfilers().getIdeServices().getMainExecutor());
            }
        }
    }

    @VisibleForTesting
    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        this.myThreadsStates.updateTraceThreadsForCapture(capture);
        this.getTimeline().getSelectionRange().set(capture.getRange());
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
        Range range = this.getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        return ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
    }

    @NotNull
    public ClockType getClockType() {
        return this.myCaptureModel.getClockType();
    }

    public void setClockType(@NotNull ClockType clockType) {
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        return this.myCaptureState;
    }

    @NotNull
    public Cpu.TraceInitiationType getCaptureInitiationType() {
        return this.myInProgressTraceInfo.getConfiguration().getInitiationType();
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (!this.myCaptureState.equals((Object)captureState)) {
            this.myCaptureState = captureState;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
            if (captureState == CaptureState.CAPTURING) {
                this.setProfilerMode(ProfilerMode.EXPANDED);
            }
        }
    }

    @NotNull
    public FilterResult applyCaptureFilter(@NotNull Filter filter) {
        FilterResult filterResult = this.myCaptureModel.applyFilter(filter);
        this.trackFilterUsage(filter, filterResult);
        return filterResult;
    }

    private void trackFilterUsage(@NotNull Filter filter, @NotNull FilterResult filterResult) {
        CaptureDetails details = this.getCaptureDetails();
        if (details == null) {
            return;
        }
        FilterMetadata filterMetadata = new FilterMetadata();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        switch (details.getType()) {
            case TOP_DOWN: {
                filterMetadata.setView(FilterMetadata.View.CPU_TOP_DOWN);
                break;
            }
            case BOTTOM_UP: {
                filterMetadata.setView(FilterMetadata.View.CPU_BOTTOM_UP);
                break;
            }
            case CALL_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_CALL_CHART);
                break;
            }
            case FLAME_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_FLAME_CHART);
            }
        }
        filterMetadata.setFeaturesUsed(filter.isMatchCase(), filter.isRegex());
        filterMetadata.setMatchedElementCount(filterResult.getMatchCount());
        filterMetadata.setTotalElementCount(filterResult.getTotalCount());
        filterMetadata.setFilterTextLength(filter.isEmpty() ? 0 : filter.getFilterString().length());
        featureTracker.trackFilterMetadata(filterMetadata);
    }

    @NotNull
    private String getProcessCaptureNameHint(long traceId) {
        return CpuProfiler.getTraceInfoFromId(this.getStudioProfilers(), traceId).getConfiguration().getAppName();
    }

    public boolean isApiInitiatedTracingInProgress() {
        return this.myCaptureState == CaptureState.CAPTURING && this.getCaptureInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        return this.myCpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        return this.myThreadsStates;
    }

    @NotNull
    public CpuKernelModel getCpuKernelModel() {
        return this.myCpuKernelModel;
    }

    @NotNull
    public CpuFramesModel getFramesModel() {
        return this.myFramesModel;
    }

    @NotNull
    public CaptureModel getCaptureModel() {
        return this.myCaptureModel;
    }

    @VisibleForTesting
    @Nullable
    CompletableFuture<CpuCapture> getCaptureFuture(long traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
            Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(String.valueOf(traceId)).build();
            Transport.BytesResponse traceResponse = this.getStudioProfilers().getClient().getTransportClient().getBytes(traceRequest);
            if (!traceResponse.getContents().isEmpty()) {
                File traceFile = CpuCaptureStage.saveCapture(traceId, traceResponse.getContents());
                capture = this.myCaptureParser.parse(traceFile, traceId, this.myCompletedTraceIdToInfoMap.get(traceId).getTraceType(), this.mySession.getPid(), this.getProcessCaptureNameHint(traceId));
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureDetails.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureDetails getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            super(dataRange);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.myCpuLegend.setCachingLastValue(true);
            this.myOthersLegend.setCachingLastValue(true);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            return this.myCpuLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            return this.myOthersLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            return this.myThreadsLegend;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForRange(Range range) {
            List<Object> traceInfos = CpuProfilerStage.this.myIsImportTraceMode ? (CpuProfilerStage.this.myImportedTraceInfo == null ? Collections.emptyList() : Collections.singletonList(CpuProfilerStage.this.myImportedTraceInfo)) : CpuProfiler.getTraceInfoFromRange(CpuProfilerStage.this.getStudioProfilers().getClient(), CpuProfilerStage.this.mySession, range, CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (Cpu.CpuTraceInfo protoTraceInfo : traceInfos) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    private class InProgressTraceHandler
    implements Updatable {
        private InProgressTraceHandler() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.getCaptureParser().isParsing()) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            Cpu.CpuTraceInfo finishedTraceToSelect = null;
            Range dataRange = CpuProfilerStage.this.getTimeline().getDataRange();
            List<Cpu.CpuTraceInfo> traceInfoList = CpuProfiler.getTraceInfoFromRange(CpuProfilerStage.this.getStudioProfilers().getClient(), CpuProfilerStage.this.mySession, dataRange, CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
            for (int i2 = 0; i2 < traceInfoList.size(); ++i2) {
                Cpu.CpuTraceInfo trace = traceInfoList.get(i2);
                if (trace.getToTimestamp() == -1L) {
                    assert (i2 == traceInfoList.size() - 1);
                    finishedTraceToSelect = null;
                    this.handleInProgressTrace(trace);
                    break;
                }
                if (CpuProfilerStage.this.myTraceIdsIterator.contains(trace.getTraceId())) continue;
                CpuProfilerStage.this.myTraceIdsIterator.addTrace(trace.getTraceId());
                CpuProfilerStage.this.myCompletedTraceIdToInfoMap.put(trace.getTraceId(), new CpuTraceInfo(trace));
                finishedTraceToSelect = trace;
                if (trace.getConfiguration().getInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API)) {
                    CpuCaptureMetadata metadata = new CpuCaptureMetadata(new ArtInstrumentedConfiguration("API tracing"));
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), metadata);
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuApiTracing(false, true, -1, -1, -1);
                }
                if (trace.getStopStatus().getStatus().equals((Object)Cpu.TraceStopStatus.Status.SUCCESS)) {
                    CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(ProfilingConfiguration.fromProto(finishedTraceToSelect.getConfiguration().getUserOptions()));
                    captureMetadata.setCaptureDurationMs(TimeUnit.NANOSECONDS.toMillis(trace.getToTimestamp() - trace.getFromTimestamp()));
                    captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(trace.getStopStatus().getStoppingTimeNs()));
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), captureMetadata);
                    continue;
                }
                CpuProfilerStage.this.trackAndLogTraceStopFailures(trace.getStopStatus());
            }
            if (finishedTraceToSelect != null) {
                CpuProfilerStage.this.myInProgressTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
                if (finishedTraceToSelect.getStopStatus().getStatus() == Cpu.TraceStopStatus.Status.SUCCESS) {
                    CpuProfilerStage.this.setAndSelectCapture(finishedTraceToSelect.getTraceId());
                } else {
                    CpuProfilerStage.this.setCaptureState(CaptureState.IDLE);
                }
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            }
        }

        private void handleInProgressTrace(@NotNull Cpu.CpuTraceInfo traceInfo) {
            if (traceInfo.equals((Object)CpuProfilerStage.this.myInProgressTraceInfo)) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            CpuProfilerStage.this.myInProgressTraceInfo = traceInfo;
            CaptureState state = CaptureState.CAPTURING;
            CpuProfilerStage.this.myCaptureStartTimeNs = CpuProfilerStage.this.myInProgressTraceInfo.getFromTimestamp();
            Common.Event statusEvent = CpuProfiler.getTraceStatusEventFromId(CpuProfilerStage.this.getStudioProfilers(), CpuProfilerStage.this.myInProgressTraceInfo.getTraceId());
            if (statusEvent.getKind() == Common.Event.Kind.CPU_TRACE_STATUS && statusEvent.getCpuTraceStatus().hasTraceStopStatus()) {
                state = CaptureState.STOPPING;
                CpuProfilerStage.this.myCaptureStopTimeNs = statusEvent.getTimestamp();
            }
            CpuProfilerStage.this.setCaptureState(state);
            CpuProfilerStage.this.getTimeline().setStreaming(true);
            if (CpuProfilerStage.this.myInProgressTraceInfo.getConfiguration().getInitiationType() == Cpu.TraceInitiationType.INITIATED_BY_API) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            } else {
                CpuProfilerStage.this.myProfilerConfigModel.setProfilingConfiguration(ProfilingConfiguration.fromProto(traceInfo.getConfiguration().getUserOptions()));
            }
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        STARTING,
        STOPPING;

    }
}

