/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.DataVisualizationColors;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreTrackModel;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CpuCoreTrackRenderer
implements TrackRenderer<CpuCoreTrackModel, ProfilerTrackRendererType> {
    @NotNull
    public JComponent render(@NotNull TrackModel<CpuCoreTrackModel, ProfilerTrackRendererType> trackModel) {
        CpuCoreTrackModel dataModel = (CpuCoreTrackModel)trackModel.getDataModel();
        StateChart stateChart = new StateChart(dataModel.getStateChartModel(), (StateChartColorProvider)new CpuCoreColorProvider(), CpuThreadInfo::getName);
        stateChart.setRenderMode(StateChart.RenderMode.TEXT);
        stateChart.setOpaque(true);
        return stateChart;
    }

    @VisibleForTesting
    protected static class CpuCoreColorProvider
    extends StateChartColorProvider<CpuThreadSliceInfo> {
        protected CpuCoreColorProvider() {
        }

        @NotNull
        public Color getColor(boolean isMouseOver, @NotNull CpuThreadSliceInfo value) {
            if (value == CpuThreadSliceInfo.NULL_THREAD) {
                return ProfilerColors.DEFAULT_BACKGROUND;
            }
            return DataVisualizationColors.INSTANCE.getColor(value.getId(), isMouseOver);
        }

        @NotNull
        public Color getFontColor(boolean isMouseOver, @NotNull CpuThreadSliceInfo value) {
            if (value == CpuThreadSliceInfo.NULL_THREAD) {
                return AdtUiUtils.DEFAULT_FONT_COLOR;
            }
            return DataVisualizationColors.INSTANCE.getFontColor(value.getId());
        }
    }
}

