/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterAccumulator;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureNode
implements HNode<CaptureNode> {
    private long myStartGlobal;
    private long myEndGlobal;
    private long myStartThread;
    private long myEndThread;
    @NotNull
    protected final List<CaptureNode> myChildren = new ArrayList<CaptureNode>();
    @NotNull
    private ClockType myClockType = ClockType.GLOBAL;
    private CaptureNode myParent;
    @NotNull
    private FilterType myFilterType = FilterType.MATCH;
    private int myDepth = 0;
    @NotNull
    private final CaptureNodeModel myData;
    @Nullable
    private AspectModel<Aspect> myAspectModel = null;

    public CaptureNode(@NotNull CaptureNodeModel model) {
        this.myData = model;
    }

    public void addChild(CaptureNode node) {
        this.myChildren.add(node);
        node.myParent = this;
    }

    @NotNull
    public List<CaptureNode> getChildren() {
        return this.myChildren;
    }

    @NotNull
    public CaptureNodeModel getData() {
        return this.myData;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    @NotNull
    public CaptureNode getChildAt(int index) {
        return this.myChildren.get(index);
    }

    @Nullable
    public CaptureNode getParent() {
        return this.myParent;
    }

    @NotNull
    public CaptureNode findRootNode() {
        CaptureNode rootNode = this;
        while (rootNode.getParent() != null) {
            rootNode = rootNode.getParent();
        }
        return rootNode;
    }

    public long getStart() {
        return this.myClockType == ClockType.THREAD ? this.myStartThread : this.myStartGlobal;
    }

    public long getEnd() {
        return this.myClockType == ClockType.THREAD ? this.myEndThread : this.myEndGlobal;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public void setStartGlobal(long startGlobal) {
        this.myStartGlobal = startGlobal;
    }

    public long getStartGlobal() {
        return this.myStartGlobal;
    }

    public void setEndGlobal(long endGlobal) {
        this.myEndGlobal = endGlobal;
    }

    public long getEndGlobal() {
        return this.myEndGlobal;
    }

    public void setStartThread(long startThread) {
        this.myStartThread = startThread;
    }

    public long getStartThread() {
        return this.myStartThread;
    }

    public void setEndThread(long endThread) {
        this.myEndThread = endThread;
    }

    public long getEndThread() {
        return this.myEndThread;
    }

    public void setClockType(@NotNull ClockType clockType) {
        this.myClockType = clockType;
    }

    @NotNull
    public AspectModel<Aspect> getAspectModel() {
        if (this.myAspectModel == null) {
            this.myAspectModel = new AspectModel();
        }
        return this.myAspectModel;
    }

    public double threadGlobalRatio() {
        long durationThread = this.myEndThread - this.myStartThread;
        long durationGlobal = this.myEndGlobal - this.myStartGlobal;
        return (double)durationThread / (double)durationGlobal;
    }

    @NotNull
    public ClockType getClockType() {
        return this.myClockType;
    }

    public void setDepth(int depth) {
        this.myDepth = depth;
    }

    @NotNull
    public List<CaptureNode> getTopKNodes(int k, @NotNull Predicate<CaptureNode> filter, @NotNull Comparator<CaptureNode> comparator) {
        PriorityQueue<CaptureNode> candidates = new PriorityQueue<CaptureNode>(k + 1, comparator);
        this.getDescendantsStream().filter(filter).forEach(node -> {
            candidates.offer((CaptureNode)node);
            if (candidates.size() > k) {
                candidates.poll();
            }
        });
        ArrayList<CaptureNode> result = new ArrayList<CaptureNode>(candidates);
        Collections.sort(result, comparator.reversed());
        return result;
    }

    public Stream<CaptureNode> getDescendantsStream() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(CaptureNode::getDescendantsStream));
    }

    @NotNull
    public FilterResult applyFilter(@NotNull Filter filter) {
        FilterAccumulator accumulator = new FilterAccumulator(!filter.isEmpty());
        this.computeFilter(filter, false, accumulator);
        if (this.myAspectModel != null) {
            this.myAspectModel.changed((Enum)Aspect.FILTER_APPLIED);
        }
        return accumulator.toFilterResult();
    }

    private void computeFilter(@NotNull Filter filter, boolean matches, @NotNull FilterAccumulator accumulator) {
        boolean nodeExactMatch = filter.matches(this.getData().getFullName());
        boolean bl = matches = matches || nodeExactMatch;
        if (nodeExactMatch) {
            accumulator.increaseMatchCount();
        }
        accumulator.increaseTotalCount();
        boolean allChildrenUnmatch = true;
        for (CaptureNode child : this.getChildren()) {
            child.computeFilter(filter, matches, accumulator);
            if (child.isUnmatched()) continue;
            allChildrenUnmatch = false;
        }
        if (!matches && allChildrenUnmatch) {
            this.setFilterType(FilterType.UNMATCH);
        } else if (nodeExactMatch && !filter.isEmpty()) {
            this.setFilterType(FilterType.EXACT_MATCH);
        } else {
            this.setFilterType(FilterType.MATCH);
        }
    }

    @NotNull
    public FilterType getFilterType() {
        return this.myFilterType;
    }

    public void setFilterType(@NotNull FilterType type) {
        this.myFilterType = type;
    }

    public boolean isUnmatched() {
        return this.getFilterType() == FilterType.UNMATCH;
    }

    public static enum Aspect {
        FILTER_APPLIED;

    }

    public static enum FilterType {
        EXACT_MATCH,
        MATCH,
        UNMATCH;

    }
}

