/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DefaultTimeline;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCpuCapture
implements CpuCapture {
    private final int myMainThreadId;
    @NotNull
    private ClockType myClockType;
    @NotNull
    private final Set<CpuThreadInfo> myAvailableThreads;
    @NotNull
    private final Map<Integer, CaptureNode> myThreadIdToNode;
    @NotNull
    private final Timeline myTimeline = new DefaultTimeline();
    private final long myTraceId;
    @NotNull
    private final Cpu.CpuTraceType myType;

    public BaseCpuCapture(long traceId, @NotNull Cpu.CpuTraceType type, @NotNull Range range, @NotNull Map<CpuThreadInfo, CaptureNode> captureTrees) {
        this.myTraceId = traceId;
        this.myType = type;
        this.myTimeline.getDataRange().set(range);
        this.myTimeline.getViewRange().set(range);
        Preconditions.checkState((!captureTrees.isEmpty() ? 1 : 0) != 0, (Object)"Trace file contained no CPU data.");
        ImmutableSet.Builder availableThreadsBuilder = ImmutableSet.builder();
        ImmutableMap.Builder threadIdToNodesBuilder = ImmutableMap.builder();
        Integer mainThreadId = null;
        Integer longestThreadId = null;
        Long longestThreadSpan = null;
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : captureTrees.entrySet()) {
            availableThreadsBuilder.add((Object)entry.getKey());
            threadIdToNodesBuilder.put((Object)entry.getKey().getId(), (Object)entry.getValue());
            if (mainThreadId == null && entry.getKey().isMainThread()) {
                mainThreadId = entry.getKey().getId();
                continue;
            }
            if (longestThreadSpan != null && longestThreadSpan >= entry.getValue().getDuration()) continue;
            longestThreadId = entry.getKey().getId();
            longestThreadSpan = entry.getValue().getDuration();
        }
        this.myAvailableThreads = availableThreadsBuilder.build();
        this.myThreadIdToNode = threadIdToNodesBuilder.build();
        this.myMainThreadId = mainThreadId != null ? mainThreadId.intValue() : longestThreadId.intValue();
        CaptureNode mainNode = this.getCaptureNode(this.myMainThreadId);
        assert (mainNode != null);
        this.myClockType = mainNode.getClockType();
    }

    @Override
    public int getMainThreadId() {
        return this.myMainThreadId;
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.myTimeline;
    }

    @Override
    @Nullable
    public CaptureNode getCaptureNode(int threadId) {
        return this.myThreadIdToNode.get(threadId);
    }

    @Override
    @NotNull
    public Set<CpuThreadInfo> getThreads() {
        return this.myAvailableThreads;
    }

    @Override
    @NotNull
    public Collection<CaptureNode> getCaptureNodes() {
        return this.myThreadIdToNode.values();
    }

    @Override
    public boolean containsThread(int threadId) {
        return this.getCaptureNode(threadId) != null;
    }

    @Override
    public long getTraceId() {
        return this.myTraceId;
    }

    @Override
    public void updateClockType(@NotNull ClockType clockType) {
        if (this.myClockType == clockType) {
            return;
        }
        this.myClockType = clockType;
        for (CaptureNode tree : this.getCaptureNodes()) {
            if (tree == null) continue;
            tree.getDescendantsStream().forEach(node -> node.setClockType(clockType));
        }
    }

    @Override
    public boolean isDualClock() {
        return this.myType == Cpu.CpuTraceType.ART;
    }

    @Override
    @NotNull
    public Cpu.CpuTraceType getType() {
        return this.myType;
    }
}

