/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.analytics.energy;

import com.android.tools.profilers.energy.EnergyDuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EnergyRangeMetadata {
    private final List<EnergyEventCount> myEventCounts = new ArrayList<EnergyEventCount>();

    public EnergyRangeMetadata(@NotNull List<EnergyDuration> energyDurations) {
        HashMap<EnergyDuration.Kind, Integer> kindCounts = new HashMap<EnergyDuration.Kind, Integer>();
        for (EnergyDuration energyDuration : energyDurations) {
            kindCounts.compute(energyDuration.getKind(), (kind, count2) -> count2 == null ? 1 : count2 + 1);
        }
        for (Map.Entry entry : kindCounts.entrySet()) {
            this.myEventCounts.add(new EnergyEventCount((EnergyDuration.Kind)((Object)entry.getKey()), (Integer)entry.getValue()));
        }
    }

    @NotNull
    public List<EnergyEventCount> getEventCounts() {
        return this.myEventCounts;
    }

    public static final class EnergyEventCount {
        private final EnergyDuration.Kind myKind;
        private final int myCount;

        public EnergyEventCount(@NotNull EnergyDuration.Kind kind, int count2) {
            this.myKind = kind;
            this.myCount = count2;
        }

        @NotNull
        public EnergyDuration.Kind getKind() {
            return this.myKind;
        }

        public int getCount() {
            return this.myCount;
        }
    }
}

