/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Stage<T extends Timeline>
extends AspectObserver {
    protected static final long PROFILING_INSTRUCTIONS_EASE_OUT_NS = TimeUnit.SECONDS.toNanos(3L);
    private final StudioProfilers myProfilers;
    private ProfilerMode myProfilerMode = ProfilerMode.NORMAL;
    @Nullable
    private TooltipModel myTooltip;

    public Stage(@NotNull StudioProfilers profilers) {
        this.myProfilers = profilers;
    }

    @NotNull
    public StudioProfilers getStudioProfilers() {
        return this.myProfilers;
    }

    @NotNull
    public abstract T getTimeline();

    public abstract void enter();

    public abstract void exit();

    @NotNull
    public final ProfilerMode getProfilerMode() {
        return this.myProfilerMode;
    }

    @Nullable
    public TooltipModel getTooltip() {
        return this.myTooltip;
    }

    protected final void setProfilerMode(@NotNull ProfilerMode profilerMode) {
        if (this.myProfilerMode != profilerMode) {
            this.myProfilerMode = profilerMode;
            this.getStudioProfilers().modeChanged();
        }
    }

    public void setTooltip(TooltipModel tooltip2) {
        if (tooltip2 != null && this.myTooltip != null && tooltip2.getClass().equals(this.myTooltip.getClass())) {
            return;
        }
        if (this.myTooltip != null) {
            this.myTooltip.dispose();
        }
        this.myTooltip = tooltip2;
        this.getStudioProfilers().changed(ProfilerAspect.TOOLTIP);
    }

    @NotNull
    public Stage<?> getParentStage() {
        return new StudioMonitorStage(this.getStudioProfilers());
    }

    @NotNull
    public Class<? extends Stage> getHomeStageClass() {
        return ((Object)((Object)this)).getClass();
    }

    @Nullable
    public String getConfirmExitMessage() {
        return null;
    }

    public boolean isInteractingWithTimeline() {
        return true;
    }
}

