/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.model.HNode;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.google.common.annotations.VisibleForTesting;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class ChartTooltipViewBase<T extends HNode<T>>
extends MouseAdapter {
    @NotNull
    private final HTreeChart<T> myChart;
    @NotNull
    private final TooltipComponent myTooltipComponent;
    @NotNull
    private final JPanel myContent;

    protected ChartTooltipViewBase(@NotNull HTreeChart<T> chart, @NotNull JLayeredPane tooltipRoot) {
        this.myChart = chart;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        this.myContent.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        this.myContent.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myTooltipComponent = new TooltipComponent.Builder((JComponent)this.myContent, chart, tooltipRoot).build();
        this.myTooltipComponent.registerListenersOn(chart);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.myTooltipComponent.setVisible(false);
        HNode node = this.myChart.getNodeAt(e.getPoint());
        if (node != null) {
            this.myTooltipComponent.setVisible(true);
            this.showTooltip(node);
        }
    }

    @VisibleForTesting
    public TooltipComponent getTooltipComponent() {
        return this.myTooltipComponent;
    }

    protected JPanel getTooltipContainer() {
        return this.myContent;
    }

    @VisibleForTesting
    public abstract void showTooltip(@NotNull T var1);
}

