/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.GradleTaskProperty;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0014J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleTaskContainerContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "getParentClassName", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "intellij.gradle.java"})
public final class GradleTaskContainerContributor
extends NonCodeMembersContributor {
    @Nullable
    protected String getParentClassName() {
        return "org.gradle.api.tasks.TaskContainer";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Collection tasks;
        Collection collection;
        if (!(qualifierType instanceof GradleProjectAwareType)) {
            return;
        }
        boolean processProperties = ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor);
        boolean processMethods = ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor);
        if (!processProperties && !processMethods) {
            return;
        }
        PsiFile psiFile = place.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)file);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData data = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        if (name == null) {
            collection = data.tasksMap.values();
        } else {
            GradleExtensionsSettings.GradleTask gradleTask = (GradleExtensionsSettings.GradleTask)data.tasksMap.get(name);
            if (gradleTask == null) {
                return;
            }
            collection = tasks = (Collection)CollectionsKt.listOf((Object)gradleTask);
        }
        if (tasks.isEmpty()) {
            return;
        }
        PsiManager manager = file.getManager();
        PsiClassType closureType = TypesUtil.createType((String)"groovy.lang.Closure", (PsiElement)((PsiElement)file));
        for (GradleExtensionsSettings.GradleTask task : tasks) {
            GradleTaskProperty property;
            PsiClassType taskType = TypesUtil.createType((String)task.typeFqn, (PsiElement)((PsiElement)file));
            if (processProperties && !processor.execute((PsiElement)(property = new GradleTaskProperty(task, (PsiElement)file)), state)) {
                return;
            }
            if (!processMethods) continue;
            GrLightMethodBuilder grLightMethodBuilder = new GrLightMethodBuilder(manager, task.name);
            boolean bl = false;
            boolean bl2 = false;
            GrLightMethodBuilder $this$apply = grLightMethodBuilder;
            boolean bl3 = false;
            $this$apply.setReturnType((PsiType)taskType);
            $this$apply.addParameter("configuration", (PsiType)closureType);
            GrLightMethodBuilder method = grLightMethodBuilder;
            if (processor.execute((PsiElement)method, state)) continue;
            return;
        }
    }
}

