/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEvent;

public abstract class AbstractTestEvent
implements TestEvent {
    private final GradleTestsExecutionConsole myExecutionConsole;

    public AbstractTestEvent(GradleTestsExecutionConsole executionConsole) {
        this.myExecutionConsole = executionConsole;
    }

    public GradleTestsExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    protected SMTestRunnerResultsForm getResultsViewer() {
        return this.myExecutionConsole.getResultsViewer();
    }

    protected Project getProject() {
        return this.myExecutionConsole.getProperties().getProject();
    }

    protected GradleConsoleProperties getProperties() {
        return (GradleConsoleProperties)this.getExecutionConsole().getProperties();
    }

    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        return name == null ? "java:test://" + fqClassName : "java:test://" + StringUtil.getQualifiedName((String)fqClassName, (String)StringUtil.trimEnd((String)name, (String)"()"));
    }

    @Nullable
    protected SMTestProxy findTestProxy(String proxyId) {
        return this.getExecutionConsole().getTestsMap().get(proxyId);
    }

    protected void registerTestProxy(String proxyId, SMTestProxy testProxy) {
        this.myExecutionConsole.getTestsMap().put(proxyId, testProxy);
    }

    protected String decode(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }

    protected boolean showInternalTestNodes() {
        return GradleConsoleProperties.SHOW_INTERNAL_TEST_NODES.value((AbstractProperty.AbstractPropertyContainer)this.getProperties());
    }
}

