/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.PatternGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class TestClassGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return GradleExternalTaskConfigurationType.getInstance().getFactory();
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        if (((PatternGradleConfigurationProducer)RunConfigurationProducer.getInstance(PatternGradleConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        PsiClass testClass = this.getPsiClassForLocation(contextLocation);
        if (testClass == null) {
            return false;
        }
        sourceElement.set((Object)testClass);
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return false;
        }
        VirtualFile source = testClass.getContainingFile().getVirtualFile();
        TasksToRun tasksToRun = TestClassGradleConfigurationProducer.findTestsTaskToRun(source, context.getProject());
        configuration.getSettings().setExternalProjectPath(projectPath);
        configuration.getSettings().setTaskNames(ContainerUtil.map((Collection)tasksToRun, it -> TestGradleConfigurationProducerUtilKt.escapeIfNeeded(it)));
        String filter = GradleExecutionSettingsUtil.createTestFilterFrom(testClass, false);
        configuration.getSettings().setScriptParameters(filter);
        configuration.setName(testClass.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Nullable
    protected PsiMethod getPsiMethodForLocation(Location contextLocation) {
        Location<PsiMethod> location = GradleRunnerUtil.getMethodLocation(contextLocation);
        return location != null ? (PsiMethod)location.getPsiElement() : null;
    }

    @Nullable
    protected PsiClass getPsiClassForLocation(Location contextLocation) {
        PsiClass[] classes;
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return null;
        }
        TestFrameworks testFrameworks = TestFrameworks.getInstance();
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!testFrameworks.isTestClass((PsiClass)classLocation.getPsiElement())) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiClassOwner && (classes = ((PsiClassOwner)element).getClasses()).length == 1 && testFrameworks.isTestClass(classes[0])) {
            return classes[0];
        }
        return null;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        if (((PatternGradleConfigurationProducer)RunConfigurationProducer.getInstance(PatternGradleConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        if (this.getPsiMethodForLocation(contextLocation) != null) {
            return false;
        }
        PsiClass testClass = this.getPsiClassForLocation(contextLocation);
        if (testClass == null || testClass.getQualifiedName() == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        String projectPath = this.resolveProjectPath(context.getModule());
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        VirtualFile source = testClass.getContainingFile().getVirtualFile();
        if (!TestClassGradleConfigurationProducer.hasTasksInConfiguration(source, context.getProject(), configuration.getSettings())) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        int i = scriptParameters.indexOf("--tests ");
        if (i == -1) {
            return false;
        }
        String testFilter = GradleExecutionSettingsUtil.createTestFilterFrom(testClass, true);
        String filter = testFilter.substring("--tests ".length());
        String str = scriptParameters.substring(i + "--tests ".length()).trim() + ' ';
        return str.startsWith(filter) && !str.contains("--tests");
    }

    public void onFirstRun(final @NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                TestClassGradleConfigurationProducer.this.chooseTestClassConfiguration(fromContext, context, performRunnable, classes.toArray(PsiClass.EMPTY_ARRAY));
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                TestClassGradleConfigurationProducer.this.chooseTestClassConfiguration(fromContext, context, performRunnable, new PsiClass[]{aClass});
            }
        };
        Runnable runnableWithCheck = this.addCheckForTemplateParams(fromContext, context, performRunnable);
        if (inheritorChooser.runMethodInAbstractClass(context, runnableWithCheck, null, (PsiClass)fromContext.getSourceElement())) {
            return;
        }
        PsiClass psiClass = (PsiClass)fromContext.getSourceElement();
        this.chooseTestClassConfiguration(fromContext, context, runnableWithCheck, psiClass);
    }

    private void chooseTestClassConfiguration(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable, PsiClass ... classes) {
        String locationName = classes.length == 1 ? classes[0].getName() : null;
        DataContext dataContext = TestTasksChooser.contextWithLocationName(context.getDataContext(), locationName);
        this.getTestTasksChooser().chooseTestTasks(context.getProject(), dataContext, (PsiElement[])classes, tasks -> {
            ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
            ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
            Function1 createFilter = psiClass -> GradleExecutionSettingsUtil.createTestFilterFrom(psiClass, true);
            if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration((ExternalSystemTaskExecutionSettings)settings, (Module)context.getModule(), (List)tasks, (PsiElement[])classes, (Function1)createFilter)) {
                LOG.warn("Cannot apply class test configuration, uses raw run configuration");
                performRunnable.run();
                return;
            }
            configuration.setName(StringUtil.join((Object[])classes, aClass -> aClass.getName(), (String)"|"));
            performRunnable.run();
        });
    }
}

