/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleScriptType;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GradleScriptTypeDetector
extends GroovyScriptTypeDetector
implements FileTypeUsageSchemaDescriptor {
    public GradleScriptTypeDetector() {
        super((GroovyScriptType)GradleScriptType.INSTANCE);
    }

    public boolean isSpecificScriptFile(@NotNull GroovyFile script) {
        return "gradle".equals(script.getViewProvider().getVirtualFile().getExtension());
    }

    public boolean describes(@NotNull VirtualFile file) {
        String name = file.getName();
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)GroovyFileType.GROOVY_FILE_TYPE) && (name.equals("build.gradle") || name.equals("settings.gradle"));
    }
}

