/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;

public final class GradleClassFinder
extends NonClasspathClassFinder {
    public GradleClassFinder(@NotNull Project project) {
        super(project, new String[]{"java", "groovy"});
    }

    protected List<VirtualFile> calcClassRoots() {
        return GradleBuildClasspathManager.getInstance(this.myProject).getAllClasspathEntries();
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope2) {
        if (scope2 instanceof ExternalModuleBuildGlobalSearchScope) {
            GradleBuildClasspathManager buildClasspathManager = GradleBuildClasspathManager.getInstance(this.myProject);
            Map<String, PackageDirectoryCache> classFinderCache = buildClasspathManager.getClassFinderCache();
            return classFinderCache.get(((ExternalModuleBuildGlobalSearchScope)scope2).getExternalModulePath());
        }
        return super.getCache(scope2);
    }

    public void clearCache() {
        super.clearCache();
        GradleBuildClasspathManager buildClasspathManager = GradleBuildClasspathManager.getInstance(this.myProject);
        Map<String, PackageDirectoryCache> classFinderCache = buildClasspathManager.getClassFinderCache();
        classFinderCache.clear();
    }

    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        PsiClass aClass = super.findClass(qualifiedName2, scope2);
        if (aClass == null || scope2 instanceof ExternalModuleBuildGlobalSearchScope || scope2 instanceof EverythingGlobalScope) {
            return aClass;
        }
        PsiFile containingFile = aClass.getContainingFile();
        VirtualFile file = containingFile != null ? containingFile.getVirtualFile() : null;
        return file != null && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInContent(file) && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInLibrary(file) ? aClass : null;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        return scope2 instanceof ExternalModuleBuildGlobalSearchScope ? super.getSubPackages(psiPackage, scope2) : PsiPackage.EMPTY_ARRAY;
    }
}

