/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.jdwp;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.xdebugger.XDebugSession;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class NativeAwareDebugProcessHandler
extends ProcessHandler {
    @NotNull
    private final XDebugSession myNativeDebugSession;

    public NativeAwareDebugProcessHandler(@NotNull XDebugSession nativeDebugSession) {
        this.myNativeDebugSession = nativeDebugSession;
    }

    public void addDetachListener(final @NotNull DebugProcess debugProcess) {
        DebugProcessListener listener = new DebugProcessListener(){

            public void processDetached(DebugProcess process, boolean closedByUser) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)this);
                NativeAwareDebugProcessHandler.this.notifyProcessDetached();
            }
        };
        debugProcess.addDebugProcessListener(listener);
        if (debugProcess.isDetached()) {
            debugProcess.removeDebugProcessListener(listener);
            this.notifyProcessDetached();
        }
    }

    protected void destroyProcessImpl() {
        this.myNativeDebugSession.stop();
    }

    protected void detachProcessImpl() {
        this.myNativeDebugSession.stop();
    }

    public boolean detachIsDefault() {
        return true;
    }

    public OutputStream getProcessInput() {
        return null;
    }
}

