/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;

public class ProcessNameReader {
    public static boolean hasGlobalProcess(@NotNull AndroidFacet facet, @NotNull String name) {
        return ProcessNameReader.readGlobalProcessNames(facet).stream().anyMatch(globalProcessName -> name.equals(globalProcessName));
    }

    @NotNull
    private static List<String> readGlobalProcessNames(@NotNull AndroidFacet facet) {
        VirtualFile manifestFile = SourceProviderManager.getInstance((AndroidFacet)facet).getMainManifestFile();
        if (manifestFile == null) {
            return Collections.emptyList();
        }
        final LinkedList<String> result = new LinkedList<String>();
        ReadAction.run(() -> {
            PsiFile xmlFile = PsiManager.getInstance((Project)facet.getModule().getProject()).findFile(manifestFile);
            if (!(xmlFile instanceof XmlFile)) {
                return;
            }
            xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttribute(XmlAttribute attribute) {
                    String value;
                    if ("process".equals(attribute.getLocalName()) && (value = attribute.getValue()) != null && !value.startsWith(":")) {
                        result.add(value.toLowerCase());
                    }
                }
            });
        });
        return result;
    }
}

