/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.AndroidJavaDebugger;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.editor.AutoAndroidDebuggerState;
import com.android.tools.ndk.run.editor.HybridAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoAndroidDebugger
implements AndroidDebugger<AutoAndroidDebuggerState> {
    public static final String ID = "Auto";
    private HybridAndroidDebugger myHybridAndroidDebugger;
    private AndroidJavaDebugger myAndroidJavaDebugger;
    private NativeAndroidDebugger myNativeAndroidDebugger;

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return "Detect Automatically";
    }

    @NotNull
    public AutoAndroidDebuggerState createState() {
        return new AutoAndroidDebuggerState(this);
    }

    @NotNull
    public AndroidDebuggerConfigurable<AutoAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<AutoAndroidDebuggerState>(runConfiguration.getProject(), !(runConfiguration instanceof AndroidTestRunConfiguration));
    }

    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @Nullable AndroidVersion version, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull AutoAndroidDebuggerState state, @NotNull String runConfigTypeId, @Nullable String packageNameOverride) {
        boolean useNativeDebugger = this.isNativeDeployment(facet.getModule().getProject(), state.getDebuggeeModule()) || !state.getSymbolDirs().isEmpty();
        return this.getInternalDebugger(useNativeDebugger).getConnectDebuggerTask(env, version, applicationIds, facet, (AndroidDebuggerState)state, this.getId() + ":" + runConfigTypeId, packageNameOverride);
    }

    public boolean supportsProject(@NotNull Project project) {
        return GradleProjectInfo.getInstance((Project)project).isBuildWithGradle() || AndroidProjectInfo.getInstance((Project)project).isApkProject();
    }

    public void attachToClient(@NotNull Project project, @NotNull Client client, @Nullable RunConfiguration config2) {
        boolean useNativeDebugger = this.isNativeProject(project);
        this.getInternalDebugger(useNativeDebugger).attachToClient(project, client, config2);
    }

    public boolean shouldBeDefault() {
        return true;
    }

    @NotNull
    public String getAmStartOptions(@NotNull AutoAndroidDebuggerState debuggerState, @NotNull Project project, @NotNull AndroidVersion version) {
        boolean useNativeDebugger = this.isNativeDeployment(project, debuggerState.getDebuggeeModule()) || !debuggerState.getSymbolDirs().isEmpty();
        return this.getInternalDebugger(useNativeDebugger).getAmStartOptions((AndroidDebuggerState)debuggerState, project, version);
    }

    protected boolean isNativeProject(@NotNull Project project) {
        return NdkHelper.isNdkProject(project);
    }

    protected boolean isNativeDeployment(@NotNull Project project, @Nullable Module debuggeeModule) {
        return NdkHelper.isNdkDeployment(project, debuggeeModule);
    }

    private synchronized void findDebuggers() {
        if (this.myHybridAndroidDebugger != null && this.myNativeAndroidDebugger != null && this.myAndroidJavaDebugger != null) {
            return;
        }
        for (AndroidDebugger debugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            if (debugger instanceof HybridAndroidDebugger) {
                this.myHybridAndroidDebugger = (HybridAndroidDebugger)debugger;
                continue;
            }
            if (debugger instanceof NativeAndroidDebugger) {
                this.myNativeAndroidDebugger = (NativeAndroidDebugger)debugger;
                continue;
            }
            if (!(debugger instanceof AndroidJavaDebugger)) continue;
            this.myAndroidJavaDebugger = (AndroidJavaDebugger)debugger;
        }
    }

    @NotNull
    private synchronized AndroidDebugger getInternalDebugger(boolean useNativeDebugger) {
        this.findDebuggers();
        if (!useNativeDebugger) {
            return this.myAndroidJavaDebugger;
        }
        return this.myHybridAndroidDebugger;
    }
}

