/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.attach;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfiguration;
import com.android.tools.ndk.run.attach.AttachLLDBTask;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.google.common.collect.Sets;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NativeAttachState
implements RunProfileState {
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    private final AndroidNativeAttachConfiguration myRunConfig;

    NativeAttachState(@NotNull ExecutionEnvironment env, @NotNull AndroidNativeAttachConfiguration runConfig) {
        this.myEnv = env;
        this.myRunConfig = runConfig;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        Module module = ((JavaRunConfigurationModule)this.myRunConfig.getConfigurationModule()).getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        assert (facet != null);
        Client client = this.myRunConfig.getClient();
        assert (client != null);
        IDevice device = client.getDevice();
        String packageId = client.getClientData().getClientDescription();
        String packageNameOverride = this.myRunConfig.getPackageNameOverride();
        AndroidDebuggerContext androidDebuggerContext = this.myRunConfig.getAndroidDebuggerContext();
        NativeAndroidDebugger debugger = (NativeAndroidDebugger)androidDebuggerContext.getAndroidDebugger();
        NativeAndroidDebuggerState androidDebuggerState = (NativeAndroidDebuggerState)androidDebuggerContext.getAndroidDebuggerState();
        if (debugger == null || androidDebuggerState == null) {
            return null;
        }
        AttachLLDBTask debugConnectorTask = new AttachLLDBTask(this.myEnv, Sets.newHashSet((Object[])new String[]{packageId}), facet, androidDebuggerState, debugger, this.myRunConfig.getType().getId(), client, packageNameOverride);
        LaunchInfo launchInfo = new LaunchInfo(executor, runner, this.myEnv, this.myRunConfig.getConsoleProvider(false));
        AndroidProcessHandler processHandler = new AndroidProcessHandler(this.myEnv.getProject(), packageId);
        processHandler.addTargetDevice(device);
        ProcessHandlerLaunchStatus launchStatus = new ProcessHandlerLaunchStatus((ProcessHandler)processHandler);
        ProcessHandlerConsolePrinter consolePrinter = new ProcessHandlerConsolePrinter((ProcessHandler)processHandler);
        ConsoleProvider consoleProvider = this.myRunConfig.getConsoleProvider(false);
        ConsoleView console = consoleProvider.createAndAttach((Disposable)module.getProject(), (ProcessHandler)processHandler, executor);
        debugConnectorTask.perform(launchInfo, device, launchStatus, consolePrinter);
        return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
    }
}

