/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FindClassCall;
import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.GetFieldIdCall;
import com.android.tools.ndk.jni.model.GetMethodIdCall;
import com.android.tools.ndk.jni.model.JvmFieldId;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.reference.JvmClassReference;
import com.android.tools.ndk.jni.reference.JvmFieldReference;
import com.android.tools.ndk.jni.reference.JvmMethodReference;
import com.android.tools.ndk.jni.reference.JvmPackageReference;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\f\u001a!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010\u001a!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0014\" \u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0015"}, d2={"contentTextRange", "Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm.PlatformType", "Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;", "getContentTextRange", "(Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)Lcom/intellij/openapi/util/TextRange;", "buildReferencesFromFindClassCall", "", "Lcom/intellij/psi/PsiReference;", "jniCall", "Lcom/android/tools/ndk/jni/model/FindClassCall;", "classNameLiteral", "(Lcom/android/tools/ndk/jni/model/FindClassCall;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)[Lcom/intellij/psi/PsiReference;", "buildReferencesFromGetFieldIdCall", "Lcom/android/tools/ndk/jni/model/GetFieldIdCall;", "fieldNameLiteral", "(Lcom/android/tools/ndk/jni/model/GetFieldIdCall;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)[Lcom/intellij/psi/PsiReference;", "buildReferencesFromGetMethodIdCall", "Lcom/android/tools/ndk/jni/model/GetMethodIdCall;", "methodNameLiteral", "(Lcom/android/tools/ndk/jni/model/GetMethodIdCall;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)[Lcom/intellij/psi/PsiReference;", "android-ndk"})
public final class JniReferenceContributorKt {
    @NotNull
    public static final PsiReference[] buildReferencesFromFindClassCall(@NotNull FindClassCall jniCall, @NotNull OCLiteralExpression classNameLiteral) {
        Object object;
        int classNameEndPosition;
        int numberOfBrackets;
        Object object2;
        OCExpression oCExpression = jniCall.getClassNameExpression();
        DataSource dataSource = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
        if (!(dataSource instanceof StringDataSource)) {
            dataSource = null;
        }
        if ((object2 = (StringDataSource)dataSource) == null || (object2 = ((StringDataSource)object2).getString()) == null) {
            return new PsiReference[0];
        }
        Object classNameString = object2;
        for (numberOfBrackets = 0; numberOfBrackets < ((String)classNameString).length() && ((String)classNameString).charAt(numberOfBrackets) == '['; ++numberOfBrackets) {
        }
        int classNameStartPosition = numberOfBrackets == 0 ? 0 : numberOfBrackets + 1;
        int n = classNameEndPosition = numberOfBrackets == 0 ? ((String)classNameString).length() : ((String)classNameString).length() - 1;
        if (classNameEndPosition <= classNameStartPosition) {
            return new PsiReference[0];
        }
        Object object3 = classNameString;
        boolean bl = false;
        Object object4 = object3;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object4).substring(classNameStartPosition, classNameEndPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromStringOrNull(string);
        if (fullyQualifiedClassName == null) {
            return new PsiReference[0];
        }
        FullyQualifiedClassName className = fullyQualifiedClassName;
        int nameStartIndex = classNameStartPosition;
        boolean bl2 = false;
        List currentPackages = new ArrayList();
        boolean bl3 = false;
        List resultReferences = new ArrayList();
        for (String p : className.getPackages()) {
            Collection collection = currentPackages;
            boolean bl4 = false;
            collection.add(p);
            int nameEndIndex = nameStartIndex + p.length();
            Collection collection2 = resultReferences;
            object = new JvmPackageReference(CollectionsKt.joinToString$default((Iterable)currentPackages, (CharSequence)".", null, null, (int)0, null, null, (int)62, null), classNameLiteral, new TextRange(1 + nameStartIndex, 1 + nameEndIndex));
            boolean bl5 = false;
            collection2.add(object);
            nameStartIndex = nameEndIndex + 1;
        }
        boolean bl6 = false;
        List currentClasses = new ArrayList();
        for (String c : className.getClasses()) {
            Collection collection = currentClasses;
            boolean bl7 = false;
            collection.add(c);
            int nameEndIndex = nameStartIndex + c.length();
            object = resultReferences;
            JvmClassReference jvmClassReference = new JvmClassReference(new FullyQualifiedClassName(currentPackages, CollectionsKt.toMutableList((Collection)currentClasses)), classNameLiteral, new TextRange(1 + nameStartIndex, 1 + nameEndIndex));
            boolean bl8 = false;
            object.add(jvmClassReference);
            nameStartIndex = nameEndIndex + 1;
        }
        Collection $this$toTypedArray$iv = resultReferences;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiReference[] psiReferenceArray = thisCollection$iv.toArray(new PsiReference[0]);
        if (psiReferenceArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiReferenceArray;
    }

    @NotNull
    public static final PsiReference[] buildReferencesFromGetMethodIdCall(@NotNull GetMethodIdCall jniCall, @NotNull OCLiteralExpression methodNameLiteral) {
        Object object;
        Object object2;
        Object object3;
        JniInfoInferencer jniInfoInferencer2 = JniInfoInferencer.Companion.getInstance(methodNameLiteral.getProject());
        boolean bl = false;
        boolean bl2 = false;
        JniInfoInferencer $this$with = jniInfoInferencer2;
        boolean bl3 = false;
        JvmType jvmType = $this$with.inferJvmClassType(jniCall.getClassExpression());
        if (!(jvmType instanceof JvmObjectType)) {
            jvmType = null;
        }
        if ((object3 = (JvmObjectType)jvmType) == null || (object3 = ((JvmObjectType)object3).getName()) == null) {
            return new PsiReference[0];
        }
        Object className = object3;
        OCExpression oCExpression = jniCall.getMethodNameExpression();
        DataSource dataSource = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
        if (!(dataSource instanceof StringDataSource)) {
            dataSource = null;
        }
        if ((object2 = (StringDataSource)dataSource) == null || (object2 = ((StringDataSource)object2).getString()) == null) {
            return new PsiReference[0];
        }
        Object methodName = object2;
        OCExpression oCExpression2 = jniCall.getMethodTypeExpression();
        DataSource dataSource2 = oCExpression2 != null ? DataSourceKt.getDataSource((OCElement)oCExpression2) : null;
        if (!(dataSource2 instanceof StringDataSource)) {
            dataSource2 = null;
        }
        if ((object = (StringDataSource)dataSource2) == null || (object = ((StringDataSource)object).getString()) == null) {
            return new PsiReference[0];
        }
        Object methodType2 = object;
        return new PsiReference[]{(PsiReference)new JvmMethodReference(new JvmMethodId((FullyQualifiedClassName)className, (String)methodName, (String)methodType2), methodNameLiteral)};
    }

    @NotNull
    public static final PsiReference[] buildReferencesFromGetFieldIdCall(@NotNull GetFieldIdCall jniCall, @NotNull OCLiteralExpression fieldNameLiteral) {
        Object object;
        Object object2;
        JniInfoInferencer jniInfoInferencer2 = JniInfoInferencer.Companion.getInstance(fieldNameLiteral.getProject());
        boolean bl = false;
        boolean bl2 = false;
        JniInfoInferencer $this$with = jniInfoInferencer2;
        boolean bl3 = false;
        JvmType jvmType = $this$with.inferJvmClassType(jniCall.getClassExpression());
        if (!(jvmType instanceof JvmObjectType)) {
            jvmType = null;
        }
        if ((object2 = (JvmObjectType)jvmType) == null || (object2 = ((JvmObjectType)object2).getName()) == null) {
            return new PsiReference[0];
        }
        Object className = object2;
        OCExpression oCExpression = jniCall.getFieldNameExpression();
        DataSource dataSource = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
        if (!(dataSource instanceof StringDataSource)) {
            dataSource = null;
        }
        if ((object = (StringDataSource)dataSource) == null || (object = ((StringDataSource)object).getString()) == null) {
            return new PsiReference[0];
        }
        Object fieldName = object;
        return new PsiReference[]{(PsiReference)new JvmFieldReference(new JvmFieldId((FullyQualifiedClassName)className, (String)fieldName), fieldNameLiteral)};
    }

    private static final TextRange getContentTextRange(OCLiteralExpression $this$contentTextRange) {
        return $this$contentTextRange.getTextLength() >= 2 ? new TextRange(1, $this$contentTextRange.getTextLength() - 1) : $this$contentTextRange.getTextRange();
    }

    public static final /* synthetic */ TextRange access$getContentTextRange$p(OCLiteralExpression $this$access_u24contentTextRange_u24p) {
        return JniReferenceContributorKt.getContentTextRange($this$access_u24contentTextRange_u24p);
    }
}

