/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeKt;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.utils.JniMangleUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006H\u00c6\u0003J/\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u0003H\u0016R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "Lcom/android/tools/ndk/jni/model/NativeMethodId;", "className", "", "methodName", "argTypes", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "Lcom/android/tools/ndk/jni/model/JvmType;", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;Ljava/lang/String;Ljava/util/List;)V", "getArgTypes", "()Ljava/util/List;", "getClassName", "()Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "functionName", "getFunctionName", "()Ljava/lang/String;", "getMethodName", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "android-ndk"})
public final class JniNativeMethodId
extends NativeMethodId {
    @NotNull
    private final FullyQualifiedClassName className;
    @NotNull
    private final String methodName;
    @Nullable
    private final List<JvmType> argTypes;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getFunctionName() {
        String result = "Java_" + JniMangleUtilsKt.escape(this.className.getJvm()) + '_' + JniMangleUtilsKt.escape(this.methodName);
        if (this.argTypes != null) {
            result = result + "__" + JniMangleUtilsKt.escape(JvmTypeKt.serializeAsString(this.argTypes));
        }
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.className.getJava()).append('#').append(this.methodName).append('(');
        List<JvmType> list = this.argTypes;
        if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)) == null) {
            list = "<unknown>";
        }
        return stringBuilder.append((String)((Object)list)).append(')').toString();
    }

    @NotNull
    public final FullyQualifiedClassName getClassName() {
        return this.className;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @Nullable
    public final List<JvmType> getArgTypes() {
        return this.argTypes;
    }

    public JniNativeMethodId(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @Nullable List<? extends JvmType> argTypes) {
        super(null);
        this.className = className;
        this.methodName = methodName;
        this.argTypes = argTypes;
    }

    /*
     * WARNING - void declaration
     */
    public JniNativeMethodId(@NotNull String className, @NotNull String methodName, @Nullable List<String> argTypes) {
        List list;
        JniNativeMethodId jniNativeMethodId = this;
        FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromString(className);
        String string = methodName;
        List<String> list2 = argTypes;
        if (list2 != null) {
            Collection<JvmType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            String string2 = string;
            FullyQualifiedClassName fullyQualifiedClassName2 = fullyQualifiedClassName;
            JniNativeMethodId jniNativeMethodId2 = jniNativeMethodId;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                JvmType jvmType = JvmType.Companion.fromJvmString$default(JvmType.Companion, (String)it, false, 2, null);
                collection.add(jvmType);
            }
            collection = (List)destination$iv$iv;
            jniNativeMethodId = jniNativeMethodId2;
            fullyQualifiedClassName = fullyQualifiedClassName2;
            string = string2;
            list = collection;
        } else {
            list = null;
        }
        jniNativeMethodId(fullyQualifiedClassName, string, list);
    }

    public /* synthetic */ JniNativeMethodId(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = null;
        }
        this(string, string2, list);
    }

    @NotNull
    public final FullyQualifiedClassName component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @Nullable
    public final List<JvmType> component3() {
        return this.argTypes;
    }

    @NotNull
    public final JniNativeMethodId copy(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @Nullable List<? extends JvmType> argTypes) {
        return new JniNativeMethodId(className, methodName, argTypes);
    }

    public static /* synthetic */ JniNativeMethodId copy$default(JniNativeMethodId jniNativeMethodId, FullyQualifiedClassName fullyQualifiedClassName, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            fullyQualifiedClassName = jniNativeMethodId.className;
        }
        if ((n & 2) != 0) {
            string = jniNativeMethodId.methodName;
        }
        if ((n & 4) != 0) {
            list = jniNativeMethodId.argTypes;
        }
        return jniNativeMethodId.copy(fullyQualifiedClassName, string, list);
    }

    public int hashCode() {
        FullyQualifiedClassName fullyQualifiedClassName = this.className;
        String string = this.methodName;
        List<JvmType> list = this.argTypes;
        return ((fullyQualifiedClassName != null ? ((Object)fullyQualifiedClassName).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JniNativeMethodId)) break block3;
                JniNativeMethodId jniNativeMethodId = (JniNativeMethodId)object;
                if (!Intrinsics.areEqual((Object)this.className, (Object)jniNativeMethodId.className) || !Intrinsics.areEqual((Object)this.methodName, (Object)jniNativeMethodId.methodName) || !Intrinsics.areEqual(this.argTypes, jniNativeMethodId.argTypes)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @Nullable
    public static final JniNativeMethodId fromJniMethodName(@NotNull String jniMethodName) {
        return Companion.fromJniMethodName(jniMethodName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/ndk/jni/model/JniNativeMethodId$Companion;", "", "()V", "fromJniMethodName", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "jniMethodName", "", "android-ndk"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final JniNativeMethodId fromJniMethodName(@NotNull String jniMethodName) {
            if (!StringsKt.startsWith$default((String)jniMethodName, (String)"Java_", (boolean)false, (int)2, null)) {
                return null;
            }
            try {
                void fqClassName;
                List parts = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)jniMethodName, (CharSequence)"Java_"), (String[])new String[]{"__"}, (boolean)false, (int)0, (int)6, null);
                String jniClassNameAndMethodName = (String)parts.get(0);
                String jniParameterTypes = parts.size() == 2 ? (String)parts.get(1) : null;
                Pair<String, String> pair = JniMangleUtilsKt.bisectAtLast(JniMangleUtilsKt.unescape(jniClassNameAndMethodName), '/');
                String string = (String)pair.component1();
                String methodName = (String)pair.component2();
                String string2 = jniParameterTypes;
                List<JvmType> argTypes = string2 != null && (string2 = JniMangleUtilsKt.unescape(string2)) != null ? JvmTypeKt.parseJvmTypes(string2) : null;
                return new JniNativeMethodId(FullyQualifiedClassName.Companion.fromString((String)fqClassName), methodName, argTypes);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

