/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.ClassTypeInfo;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.model.RegisterNativesCall;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.service.RegisterNativesProcessor;
import com.android.tools.ndk.jni.service.RegisteredNativesBundle;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n2 \u0010\u000b\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J6\u0010\u0011\u001a\u00020\n*\u00020\u00122 \u0010\u000b\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniRegisterNativesInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/jetbrains/cidr/lang/psi/visitors/OCVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectRedundantBindings", "", "bindingToInitializer", "Lcom/intellij/util/containers/BidirectionalMultiMap;", "Lkotlin/Pair;", "Lcom/android/tools/ndk/jni/model/JvmMethodId;", "Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "Lcom/jetbrains/cidr/lang/psi/OCCompoundInitializer;", "inspectMethods", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "android-ndk"})
public final class JniRegisterNativesInspection
extends JniInspectionTool {
    @NotNull
    public OCVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniRegisterNativesInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = this$0;
                this.this$0 = jniRegisterNativesInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof RegisterNativesCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (RegisterNativesCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call2 = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int inverseSampleRate$iv$iv = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    Object object;
                    void call3;
                    JniUsageEventReporter $this$reportJniPerf$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    JniInfoInferencer inferencer = (JniInfoInferencer)expression.getProject().getComponent(JniInfoInferencer.class);
                    RegisterNativesCall registerNativesCall = (RegisterNativesCall)call2;
                    JniInfoInferencer $this$visitJniCall = inferencer;
                    boolean bl3 = false;
                    JvmTypeInfo jvmTypeInfo = $this$visitJniCall.inferTypeInfo(call3.getClassExpression());
                    if (!(jvmTypeInfo instanceof ClassTypeInfo)) {
                        jvmTypeInfo = null;
                    }
                    if ((object = (ClassTypeInfo)jvmTypeInfo) == null || (object = ((ClassTypeInfo)object).getClassType()) == null) {
                    } else {
                        Object jvmType = object;
                        if (!(jvmType instanceof JvmObjectType)) {
                            InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)call3.getClassExpression(), '\'' + ((JvmType)jvmType).toShortJavaType() + "' is not a valid class to register native functions.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                        } else {
                            RegisteredNativesBundle registeredNativesBundle = RegisterNativesProcessor.Companion.getInstance($this$visitJniCall.getProject()).process((RegisterNativesCall)call3);
                            if (registeredNativesBundle == null) {
                            } else {
                                RegisteredNativesBundle bundle = registeredNativesBundle;
                                JniRegisterNativesInspection.access$inspectMethods(this.this$0, $this$visitJniCall, bundle.getBindingToInitializer(), this.$holder$inlined);
                                JniRegisterNativesInspection.access$inspectRedundantBindings(this.this$0, bundle.getBindingToInitializer(), this.$holder$inlined);
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (JniUtilsKt.access$getRandom$p().nextInt(inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspectMethods(JniInfoInferencer $this$inspectMethods, BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer> bindingToInitializer, ProblemsHolder holder) {
        JniMethodResolver jniMethodResolver2 = JniMethodResolver.Companion.getInstance($this$inspectMethods.getProject());
        Iterable $this$forEach$iv = bindingToInitializer.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List initializerExpressions;
            List<JvmMethodInfo> matchedJniMethods;
            String methodName;
            block5: {
                OCCompoundInitializer initializer = (OCCompoundInitializer)element$iv;
                boolean bl2 = false;
                Pair pair = (Pair)CollectionsKt.single((Iterable)bindingToInitializer.getKeys((Object)initializer));
                JvmMethodId jvmMethodId = (JvmMethodId)pair.component1();
                methodName = jvmMethodId.getMethodName();
                matchedJniMethods = jniMethodResolver2.findDeclaredJniMethods(jvmMethodId.getClassName(), methodName);
                initializerExpressions = initializer.getInitializerExpressions();
                if (matchedJniMethods.isEmpty()) {
                    OCExpression methodNameExpression = (OCExpression)initializerExpressions.get(0);
                    ProblemHighlightType problemType = methodNameExpression instanceof OCLiteralExpression ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                    InspectionUtilsKt.registerOcProblem(holder, (PsiElement)methodNameExpression, "Class '" + jvmMethodId.getClassName().getShortName() + "' does not declare JNI method named '" + methodName + "'.", problemType, new JniLocalQuickFix[0]);
                    continue;
                }
                Iterable $this$none$iv = matchedJniMethods;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        JvmMethodInfo it = (JvmMethodInfo)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getMethodType(), (Object)jvmMethodId.getMethodType())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            JvmMethodInfo uniqueMatch = (JvmMethodInfo)CollectionsKt.singleOrNull(matchedJniMethods);
            OCExpression methodTypeExpression = (OCExpression)initializerExpressions.get(1);
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)methodTypeExpression, uniqueMatch == null ? "The type specifier does not match any version of the overloaded JNI native method '" + methodName + "'." : "The type specifier does not match JNI native method '" + uniqueMatch.getDescription() + "'.", ProblemHighlightType.GENERIC_ERROR, this.quickFix("Fix type specifier for RegisterNatives", "Fix type specifier of method '" + methodName + '\'', (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(matchedJniMethods){
                final /* synthetic */ List $matchedJniMethods;

                /*
                 * WARNING - void declaration
                 */
                public final boolean invoke(@NotNull Project $noName_0, @NotNull ProblemDescriptor descriptor) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$matchedJniMethods;
                    ProblemDescriptor problemDescriptor = descriptor;
                    boolean $i$f$map = false;
                    void var5_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string = JniUtilsKt.quoted(it.getMethodType());
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    return InspectionUtilsKt.replaceAtHighlighted(problemDescriptor, (List<String>)collection);
                }
                {
                    this.$matchedJniMethods = list;
                    super(2);
                }
            })));
        }
    }

    private final void inspectRedundantBindings(BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer> bindingToInitializer, ProblemsHolder holder) {
        Iterable $this$forEach$iv = bindingToInitializer.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair key = (Pair)element$iv;
            boolean bl = false;
            Set initializers = bindingToInitializer.getValues((Object)key);
            if (initializers.size() <= 1) continue;
            Iterable $this$forEach$iv2 = CollectionsKt.drop((Iterable)initializers, (int)1);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                OCCompoundInitializer initializer = (OCCompoundInitializer)element$iv2;
                boolean bl2 = false;
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)initializer, "Redundant JNI binding.", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new JniLocalQuickFix[0]);
            }
        }
    }

    public JniRegisterNativesInspection() {
        super(JniInspectionEvent.JniInspectionType.REGISTER_NATIVES_INSPECTION_EVENT);
    }

    public static final /* synthetic */ void access$inspectMethods(JniRegisterNativesInspection $this, JniInfoInferencer $this$access_u24inspectMethods, BidirectionalMultiMap bindingToInitializer, ProblemsHolder holder) {
        $this.inspectMethods($this$access_u24inspectMethods, (BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer>)bindingToInitializer, holder);
    }

    public static final /* synthetic */ void access$inspectRedundantBindings(JniRegisterNativesInspection $this, BidirectionalMultiMap bindingToInitializer, ProblemsHolder holder) {
        $this.inspectRedundantBindings((BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer>)bindingToInitializer, holder);
    }
}

