/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniGetFieldIdInspection$buildVisitor$;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.GetFieldIdCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmArrayType;
import com.android.tools.ndk.jni.model.JvmFieldInfo;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniGetFieldIdInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/jetbrains/cidr/lang/psi/visitors/OCVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspect", "", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "classType", "Lcom/android/tools/ndk/jni/model/JvmType;", "call", "Lcom/android/tools/ndk/jni/model/GetFieldIdCall;", "android-ndk"})
public final class JniGetFieldIdInspection
extends JniInspectionTool {
    @NotNull
    public OCVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniGetFieldIdInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = this$0;
                this.this$0 = jniGetFieldIdInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof GetFieldIdCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (GetFieldIdCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call2 = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int inverseSampleRate$iv$iv = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call3;
                    JniUsageEventReporter $this$reportJniPerf$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    JniInfoInferencer inferencer = (JniInfoInferencer)expression.getProject().getComponent(JniInfoInferencer.class);
                    GetFieldIdCall getFieldIdCall = (GetFieldIdCall)call2;
                    JniInfoInferencer $this$visitJniCall = inferencer;
                    boolean bl3 = false;
                    if (call3.getFieldNameExpression() != null && call3.getFieldTypeExpression() != null) {
                        InspectionUtilsKt.inspectClass($this$visitJniCall, this.$holder$inlined, call3.getClassExpression(), (Function2<? super JniInfoInferencer, ? super JvmType, Unit>)((Function2)new Function2<JniInfoInferencer, JvmType, Unit>((GetFieldIdCall)call3, this){
                            final /* synthetic */ GetFieldIdCall $call;
                            final /* synthetic */ buildVisitor$$inlined$visitJniCall$android_ndk$1 this$0;
                            {
                                this.$call = getFieldIdCall;
                                this.this$0 = var2_2;
                                super(2);
                            }

                            public final void invoke(@NotNull JniInfoInferencer $this$inspectClass, @NotNull JvmType classType) {
                                JvmType jvmType = classType;
                                if (jvmType instanceof JvmPrimitiveType || jvmType instanceof JvmArrayType) {
                                    InspectionUtilsKt.registerOcProblem(this.this$0.$holder$inlined, (PsiElement)this.$call.getClassExpression(), '\'' + classType.toShortJavaType() + "' does not have any member fields.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                                } else if (jvmType instanceof JvmObjectType) {
                                    JniGetFieldIdInspection.access$inspect(this.this$0.this$0, $this$inspectClass, classType, this.$call, this.this$0.$holder$inlined);
                                }
                            }
                        }));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (JniUtilsKt.access$getRandom$p().nextInt(inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspect(JniInfoInferencer $this$inspect, JvmType classType, GetFieldIdCall call2, ProblemsHolder holder) {
        OCExpression oCExpression = call2.getFieldNameExpression();
        if (oCExpression == null) {
            return;
        }
        OCExpression fieldNameExpression = oCExpression;
        OCExpression oCExpression2 = call2.getFieldTypeExpression();
        if (oCExpression2 == null) {
            return;
        }
        OCExpression fieldTypeExpression = oCExpression2;
        PsiClass psiClass = JniInfoInferencer.findPsiClass$default($this$inspect, classType, false, 1, null);
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        DataSource dataSource = DataSourceKt.getDataSource((OCElement)fieldNameExpression);
        if (!(dataSource instanceof StringDataSource)) {
            dataSource = null;
        }
        StringDataSource stringDataSource = (StringDataSource)dataSource;
        if (stringDataSource == null) {
            return;
        }
        StringDataSource fieldNameDataSource = stringDataSource;
        DataSource dataSource2 = DataSourceKt.getDataSource((OCElement)fieldTypeExpression);
        if (!(dataSource2 instanceof StringDataSource)) {
            dataSource2 = null;
        }
        StringDataSource stringDataSource2 = (StringDataSource)dataSource2;
        if (stringDataSource2 == null) {
            return;
        }
        StringDataSource fieldTypeDataSource = stringDataSource2;
        String fieldName = fieldNameDataSource.getString();
        PsiField matchedField = psiClass2.findFieldByName(fieldName, true);
        if (matchedField == null) {
            ProblemHighlightType problemType = Intrinsics.areEqual((Object)fieldNameDataSource.getSourceExpression(), (Object)call2.getFieldNameExpression()) ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)fieldNameExpression, "Class '" + classType.toShortJavaType() + "' has no field named '" + fieldName + "'.", problemType, new JniLocalQuickFix[0]);
            return;
        }
        JvmFieldInfo jvmFieldInfo = JvmFieldInfo.Companion.fromPsiField(matchedField);
        if (jvmFieldInfo == null) {
            return;
        }
        JvmFieldInfo fieldInfo = jvmFieldInfo;
        if (Intrinsics.areEqual((Object)fieldInfo.getFieldType().toJvmType(), (Object)fieldTypeDataSource.getString()) ^ true) {
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)fieldTypeExpression, "Incorrect type specifier for field '" + fieldName + "'.", ProblemHighlightType.GENERIC_ERROR, this.quickFix("Fix type specifier in GetFieldID call", "Fix type specifier of field '" + fieldName + '\'', (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(fieldInfo){
                final /* synthetic */ JvmFieldInfo $fieldInfo;

                public final boolean invoke(@NotNull Project $noName_0, @NotNull ProblemDescriptor descriptor) {
                    return InspectionUtilsKt.replaceAtHighlighted(descriptor, JniUtilsKt.quoted(this.$fieldInfo.getFieldType().toJvmType()));
                }
                {
                    this.$fieldInfo = jvmFieldInfo;
                    super(2);
                }
            })));
            return;
        }
        if (fieldInfo.isStatic() != call2.isStatic()) {
            boolean shouldBeStatic = fieldInfo.isStatic();
            GetFieldIdCall correctCall = call2.toggleStaticity();
            InspectionUtilsKt.registerOcProblem(holder, call2.getFunctionIdentifier(), '\'' + fieldName + "' is " + (shouldBeStatic ? "a static" : "an instance") + " field and should be acquired by " + '\'' + correctCall.getFunctionName() + "'.", ProblemHighlightType.GENERIC_ERROR, this.quickFix("Fix JNI GetFieldID call", "Replace with '" + correctCall.getFunctionName() + '\'', (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(correctCall){
                final /* synthetic */ GetFieldIdCall $correctCall;

                public final boolean invoke(@NotNull Project $noName_0, @NotNull ProblemDescriptor descriptor) {
                    return InspectionUtilsKt.replaceAtHighlighted(descriptor, this.$correctCall.getFunctionName());
                }
                {
                    this.$correctCall = getFieldIdCall;
                    super(2);
                }
            })));
        }
    }

    public JniGetFieldIdInspection() {
        super(JniInspectionEvent.JniInspectionType.FIND_FIELD_INSPECTION_EVENT);
    }

    public static final /* synthetic */ void access$inspect(JniGetFieldIdInspection $this, JniInfoInferencer $this$access_u24inspect, JvmType classType, GetFieldIdCall call2, ProblemsHolder holder) {
        $this.inspect($this$access_u24inspect, classType, call2, holder);
    }
}

