/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniFindClassInspection;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.FindClassCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmArrayType;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.service.JniInfoInferencerKt;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\n*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniFindClassInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/jetbrains/cidr/lang/psi/visitors/OCVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "toProperFindClassArgument", "", "Lcom/android/tools/ndk/jni/model/JvmType;", "insideArray", "android-ndk"})
public final class JniFindClassInspection
extends JniInspectionTool {
    @NotNull
    public OCVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniFindClassInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = this$0;
                this.this$0 = jniFindClassInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof FindClassCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (FindClassCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call2 = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int inverseSampleRate$iv$iv = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call3;
                    OCExpression classNameExpression;
                    JniUsageEventReporter $this$reportJniPerf$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    JniInfoInferencer inferencer = (JniInfoInferencer)expression.getProject().getComponent(JniInfoInferencer.class);
                    FindClassCall findClassCall = (FindClassCall)call2;
                    JniInfoInferencer $this$visitJniCall = inferencer;
                    boolean bl3 = false;
                    OCExpression oCExpression = classNameExpression = call3.getClassNameExpression();
                    DataSource dataSource = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
                    if (!(dataSource instanceof StringDataSource)) {
                        dataSource = null;
                    }
                    StringDataSource stringDataSource = (StringDataSource)dataSource;
                    if (stringDataSource == null) {
                    } else {
                        ProblemHighlightType problemType;
                        StringDataSource classNameDataSource = stringDataSource;
                        JvmType classType = JniInfoInferencerKt.toJvmTypeAsClassName(classNameDataSource.getString());
                        ProblemHighlightType problemHighlightType = problemType = classNameExpression instanceof OCLiteralExpression ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                        if (classType == null || classType instanceof JvmPrimitiveType) {
                            InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)classNameExpression, '\'' + classNameDataSource.getString() + "' is not a valid class name.", problemType, new JniLocalQuickFix[0]);
                        } else {
                            buildVisitor.1.1 $fun$getBaseType$1 = buildVisitor.1.1.INSTANCE;
                            JvmType baseType = $fun$getBaseType$1.invoke(classType);
                            if (!(baseType instanceof JvmPrimitiveType) && JniInfoInferencer.findPsiClass$default($this$visitJniCall, baseType, false, 1, null) == null) {
                                InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)classNameExpression, "Cannot find class '" + classNameDataSource.getString() + "' in project.", problemType, new JniLocalQuickFix[0]);
                            } else {
                                String properFindClassArg = JniFindClassInspection.toProperFindClassArgument$default(this.this$0, classType, false, 1, null);
                                if (Intrinsics.areEqual((Object)properFindClassArg, (Object)classNameDataSource.getString()) ^ true) {
                                    InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)classNameExpression, '\'' + classNameDataSource.getString() + "' is not a valid way to specify class name.", ProblemHighlightType.GENERIC_ERROR, this.this$0.quickFix("Fix JNI FindClass argument format", "Replace '" + properFindClassArg + '\'', (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(properFindClassArg){
                                        final /* synthetic */ String $properFindClassArg;
                                        {
                                            this.$properFindClassArg = string;
                                            super(2);
                                        }

                                        public final boolean invoke(@NotNull Project $noName_0, @NotNull ProblemDescriptor descriptor) {
                                            return InspectionUtilsKt.replaceAtHighlighted(descriptor, JniUtilsKt.quoted(this.$properFindClassArg));
                                        }
                                    })));
                                }
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (JniUtilsKt.access$getRandom$p().nextInt(inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String toProperFindClassArgument(JvmType $this$toProperFindClassArgument, boolean insideArray) {
        String string;
        JvmType jvmType = $this$toProperFindClassArgument;
        if (jvmType instanceof JvmPrimitiveType) {
            if (!insideArray) throw (Throwable)((Object)new AssertionError((Object)"impossible since previous logic has eliminated this code path"));
            string = $this$toProperFindClassArgument.toJvmType();
            return string;
        } else if (jvmType instanceof JvmArrayType) {
            string = '[' + this.toProperFindClassArgument(((JvmArrayType)$this$toProperFindClassArgument).getType(), true);
            return string;
        } else {
            if (!(jvmType instanceof JvmObjectType)) throw new NoWhenBranchMatchedException();
            string = insideArray ? 'L' + ((JvmObjectType)$this$toProperFindClassArgument).getName().getJvm() + ';' : ((JvmObjectType)$this$toProperFindClassArgument).getName().getJvm();
        }
        return string;
    }

    static /* synthetic */ String toProperFindClassArgument$default(JniFindClassInspection jniFindClassInspection, JvmType jvmType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return jniFindClassInspection.toProperFindClassArgument(jvmType, bl);
    }

    public JniFindClassInspection() {
        super(JniInspectionEvent.JniInspectionType.FIND_CLASS_INSPECTION_EVENT);
    }
}

