/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.CallNonvirtualMethodCall;
import com.android.tools.ndk.jni.model.ClassTypeInfo;
import com.android.tools.ndk.jni.model.ConcreteTypeInfo;
import com.android.tools.ndk.jni.model.IllegalTypeInfo;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodCall;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeInfo;
import com.android.tools.ndk.jni.model.SimpleTypeInfo;
import com.android.tools.ndk.jni.model.WildcardTypeInfo;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.service.JvmTypeChecker;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u000e\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u000f\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniCallNonvirtualMethodInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/jetbrains/cidr/lang/psi/visitors/OCVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectClass", "", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "call", "Lcom/android/tools/ndk/jni/model/CallNonvirtualMethodCall;", "inspectReceiver", "inspectTypeVariation", "android-ndk"})
public final class JniCallNonvirtualMethodInspection
extends JniInspectionTool {
    @NotNull
    public OCVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniCallNonvirtualMethodInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = this$0;
                this.this$0 = jniCallNonvirtualMethodInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof CallNonvirtualMethodCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (CallNonvirtualMethodCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call2 = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int inverseSampleRate$iv$iv = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call3;
                    JniUsageEventReporter $this$reportJniPerf$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    JniInfoInferencer inferencer = (JniInfoInferencer)expression.getProject().getComponent(JniInfoInferencer.class);
                    CallNonvirtualMethodCall callNonvirtualMethodCall = (CallNonvirtualMethodCall)call2;
                    JniInfoInferencer $this$visitJniCall = inferencer;
                    boolean bl3 = false;
                    JniCallNonvirtualMethodInspection.access$inspectReceiver(this.this$0, $this$visitJniCall, (CallNonvirtualMethodCall)call3, this.$holder$inlined);
                    JniCallNonvirtualMethodInspection.access$inspectClass(this.this$0, $this$visitJniCall, (CallNonvirtualMethodCall)call3, this.$holder$inlined);
                    InspectionUtilsKt.inspectMethodIdBelongsToClass($this$visitJniCall, call3.getClassExpression(), this.$holder$inlined, call3.getMethodIdExpression());
                    InspectionUtilsKt.inspectCallArgs($this$visitJniCall, (JvmMethodCall)call3, this.$holder$inlined);
                    JniCallNonvirtualMethodInspection.access$inspectTypeVariation(this.this$0, $this$visitJniCall, (CallNonvirtualMethodCall)call3, this.$holder$inlined);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (JniUtilsKt.access$getRandom$p().nextInt(inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspectReceiver(JniInfoInferencer $this$inspectReceiver, CallNonvirtualMethodCall call2, ProblemsHolder holder) {
        JvmType jvmType;
        JvmTypeInfo jvmTypeInfo = $this$inspectReceiver.inferTypeInfo(call2.getObjectExpression());
        if (jvmTypeInfo == null) {
            return;
        }
        JvmTypeInfo receiverType = jvmTypeInfo;
        if (receiverType instanceof WildcardTypeInfo) {
            jvmType = ((WildcardTypeInfo)receiverType).getBound();
        } else if (receiverType instanceof ConcreteTypeInfo) {
            jvmType = ((ConcreteTypeInfo)receiverType).getType();
        } else {
            if (Intrinsics.areEqual((Object)receiverType, (Object)IllegalTypeInfo.INSTANCE)) {
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call2.getObjectExpression(), "Not a valid JVM object.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        JvmType receiverType2 = jvmType;
        if (receiverType2 instanceof JvmPrimitiveType) {
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call2.getObjectExpression(), "Expected a JVM object but got a primitive value of type '" + receiverType2.toShortJavaType() + "'.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
        }
    }

    private final void inspectClass(JniInfoInferencer $this$inspectClass, CallNonvirtualMethodCall call2, ProblemsHolder holder) {
        Object object;
        Object object2;
        JvmTypeInfo jvmTypeInfo = $this$inspectClass.inferTypeInfo(call2.getObjectExpression());
        if (!(jvmTypeInfo instanceof SimpleTypeInfo)) {
            jvmTypeInfo = null;
        }
        if ((object2 = (SimpleTypeInfo)jvmTypeInfo) == null || (object2 = ((SimpleTypeInfo)object2).getType()) == null) {
            return;
        }
        Object receiverType = object2;
        if (receiverType instanceof JvmPrimitiveType) {
            return;
        }
        JvmTypeInfo jvmTypeInfo2 = $this$inspectClass.inferTypeInfo(call2.getClassExpression());
        if (!(jvmTypeInfo2 instanceof ClassTypeInfo)) {
            jvmTypeInfo2 = null;
        }
        if ((object = (ClassTypeInfo)jvmTypeInfo2) == null || (object = ((ClassTypeInfo)object).getClassType()) == null) {
            return;
        }
        Object classType = object;
        JvmTypeChecker jvmTypeChecker = JvmTypeChecker.Companion.getInstance(call2.getCallExpression().getProject());
        boolean bl = false;
        boolean bl2 = false;
        JvmTypeChecker $this$with = jvmTypeChecker;
        boolean bl3 = false;
        if (!JvmTypeChecker.isAssignableFrom$default($this$with, (JvmType)classType, (JvmType)receiverType, false, 4, null)) {
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call2.getClassExpression(), '\'' + ((JvmType)classType).toShortJavaType() + "' is not a super class of '" + ((JvmType)receiverType).toShortJavaType() + "'.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
        }
    }

    private final void inspectTypeVariation(JniInfoInferencer $this$inspectTypeVariation, CallNonvirtualMethodCall call2, ProblemsHolder holder) {
        JvmPrimitiveType expectedType;
        JvmMethodInfo jvmMethodInfo = $this$inspectTypeVariation.inferMethodInfo(call2.getMethodIdExpression());
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo methodInfo = jvmMethodInfo;
        JvmType jvmType = methodInfo.getReturnType();
        if (!(jvmType instanceof JvmPrimitiveType)) {
            jvmType = null;
        }
        if (Intrinsics.areEqual((Object)(expectedType = (JvmPrimitiveType)jvmType), (Object)call2.getType()) ^ true) {
            CallNonvirtualMethodCall fixedCall = call2.alterType(expectedType);
            InspectionUtilsKt.registerOcProblem(holder, call2.getFunctionIdentifier(), "Expected to be " + fixedCall.getFunctionName() + " for " + methodInfo.getDescription() + '.', ProblemHighlightType.GENERIC_ERROR, this.quickFix("Fix Non-virtual method call.", "Replace with '" + fixedCall.getFunctionName() + '\'', (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(fixedCall){
                final /* synthetic */ CallNonvirtualMethodCall $fixedCall;

                public final boolean invoke(@NotNull Project $noName_0, @NotNull ProblemDescriptor descriptor) {
                    return InspectionUtilsKt.replaceAtHighlighted(descriptor, this.$fixedCall.getFunctionName());
                }
                {
                    this.$fixedCall = callNonvirtualMethodCall;
                    super(2);
                }
            })));
        }
    }

    public JniCallNonvirtualMethodInspection() {
        super(JniInspectionEvent.JniInspectionType.CALL_METHOD_INSPECTION_EVENT);
    }

    public static final /* synthetic */ void access$inspectReceiver(JniCallNonvirtualMethodInspection $this, JniInfoInferencer $this$access_u24inspectReceiver, CallNonvirtualMethodCall call2, ProblemsHolder holder) {
        $this.inspectReceiver($this$access_u24inspectReceiver, call2, holder);
    }

    public static final /* synthetic */ void access$inspectClass(JniCallNonvirtualMethodInspection $this, JniInfoInferencer $this$access_u24inspectClass, CallNonvirtualMethodCall call2, ProblemsHolder holder) {
        $this.inspectClass($this$access_u24inspectClass, call2, holder);
    }

    public static final /* synthetic */ void access$inspectTypeVariation(JniCallNonvirtualMethodInspection $this, JniInfoInferencer $this$access_u24inspectTypeVariation, CallNonvirtualMethodCall call2, ProblemsHolder holder) {
        $this.inspectTypeVariation($this$access_u24inspectTypeVariation, call2, holder);
    }
}

