/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;

public final class TextMateEditorUtils {
    @Nullable
    public static CharSequence getCurrentScopeSelector(@NotNull EditorEx editor) {
        TextMateLanguageDescriptor languageDescriptor;
        VirtualFile file;
        EditorHighlighter highlighter = editor.getHighlighter();
        SelectionModel selection = editor.getSelectionModel();
        int offset = selection.hasSelection() ? selection.getSelectionStart() : editor.getCaretModel().getOffset();
        HighlighterIterator iterator = highlighter.createIterator(offset);
        String result = null;
        if (offset != 0 || !iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            String string = result = tokenType != null ? tokenType.toString() : null;
        }
        if (result == null && (file = editor.getVirtualFile()) != null && (languageDescriptor = TextMateService.getInstance().getLanguageDescriptorByFileName(file.getName())) != null) {
            return languageDescriptor.getScopeName();
        }
        return result;
    }

    @Nullable
    public static TextMateBracePair getHighlightingPairForLeftChar(char c, @Nullable String currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleLeftHighlightingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.leftChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getHighlightingPairForRightChar(char c, @Nullable String currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleRightHighlightingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.rightChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getSmartTypingPairForLeftChar(char c, @Nullable CharSequence currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleLeftSmartTypingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.leftChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getSmartTypingPairForRightChar(char c, @Nullable CharSequence currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleRightSmartTypingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.rightChar) continue;
            return pair;
        }
        return null;
    }

    private static Set<TextMateBracePair> getAllPairsForMatcher(@Nullable String selector) {
        HashSet<TextMateBracePair> result = new HashSet<TextMateBracePair>();
        if (selector != null) {
            List preferencesForSelector = TextMateService.getInstance().getPreferencesRegistry().getPreferences((CharSequence)selector);
            for (Preferences preferences : preferencesForSelector) {
                Set highlightingPairs = preferences.getHighlightingPairs();
                if (highlightingPairs == null) continue;
                if (highlightingPairs.isEmpty()) {
                    return Collections.emptySet();
                }
                result.addAll(highlightingPairs);
            }
            for (Preferences preferences : preferencesForSelector) {
                Set smartTypingPairs = preferences.getSmartTypingPairs();
                if (smartTypingPairs == null) continue;
                result.addAll(preferences.getSmartTypingPairs());
            }
        }
        result.addAll(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        return result;
    }

    private static Set<TextMateBracePair> getSmartTypingPairs(@Nullable CharSequence currentSelector) {
        if (currentSelector != null) {
            List preferencesForSelector = TextMateService.getInstance().getPreferencesRegistry().getPreferences(currentSelector);
            for (Preferences preferences : preferencesForSelector) {
                Set smartTypingPairs = preferences.getSmartTypingPairs();
                if (smartTypingPairs == null) continue;
                if (smartTypingPairs.isEmpty()) {
                    return Collections.emptySet();
                }
                HashSet<TextMateBracePair> result = new HashSet<TextMateBracePair>(smartTypingPairs);
                result.addAll(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
                return result;
            }
        }
        return new HashSet<TextMateBracePair>(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    private TextMateEditorUtils() {
    }

    public static void processExtensions(@NotNull CharSequence fileName, @NotNull Processor<? super CharSequence> processor) {
        CharSequence extension;
        if (!processor.process((Object)fileName)) {
            return;
        }
        int index = StringUtil.indexOf((CharSequence)fileName, (char)'.');
        while (index >= 0 && (extension = fileName.subSequence(index + 1, fileName.length())).length() != 0) {
            if (!processor.process((Object)extension)) {
                return;
            }
            index = StringUtil.indexOf((CharSequence)fileName, (char)'.', (int)(index + 1));
        }
    }
}

