/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;

public class CommentLanguageInjector
implements MultiHostInjector {
    private final LanguageInjectionSupport myInjectorSupport = new AbstractLanguageInjectionSupport(){

        @Override
        @NotNull
        public String getId() {
            return "comment";
        }

        @Override
        public boolean isApplicableTo(PsiLanguageInjectionHost host) {
            return true;
        }

        public Class @NotNull [] getPatternClasses() {
            return ArrayUtil.EMPTY_CLASS_ARRAY;
        }
    };

    public CommentLanguageInjector(@NotNull Project project) {
        Configuration.getProjectInstance(project);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Collections.singletonList(PsiLanguageInjectionHost.class);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        BaseInjection injection;
        if (!(context instanceof PsiLanguageInjectionHost) || context instanceof PsiComment) {
            return;
        }
        if (!((PsiLanguageInjectionHost)context).isValidHost()) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        boolean applicableFound = false;
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            BaseInjection injection2;
            if (!support.isApplicableTo(host) || support == this.myInjectorSupport && applicableFound) continue;
            applicableFound = true;
            if (!support.useDefaultCommentInjector() || (injection2 = support.findCommentInjection((PsiElement)host, null)) == null || !InjectorUtils.registerInjectionSimple(host, injection2, support, registrar)) continue;
            return;
        }
        BaseInjection baseInjection = injection = !applicableFound ? this.myInjectorSupport.findCommentInjection((PsiElement)host, null) : null;
        if (injection == null) {
            return;
        }
        InjectorUtils.registerInjectionSimple(host, injection, this.myInjectorSupport, registrar);
    }
}

