/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyReferenceBase
implements PsiPolyVariantReference,
EmptyResolveMessageProvider {
    protected final String myKey;
    protected final PsiElement myElement;
    protected boolean mySoft;
    private final TextRange myTextRange;

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element) {
        this(key, soft, element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element, TextRange range) {
        this.myKey = key;
        this.mySoft = soft;
        this.myElement = element;
        this.myTextRange = range;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    protected String getKeyText() {
        return this.myKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyReferenceBase other = (PropertyReferenceBase)o;
        return this.getElement() == other.getElement() && this.getKeyText().equals(other.getKeyText());
    }

    public int hashCode() {
        return this.getKeyText().hashCode();
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.myTextRange;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myKey;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("not implemented");
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (!PropertyReferenceBase.isProperty(element)) {
            return false;
        }
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement el = result.getElement();
            if (el == null || !el.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    protected void addKey(Object property, Set<Object> variants) {
        variants.add(property);
    }

    protected void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return PropertiesBundle.message("unresolved.property.key", new Object[0]);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        List<Object> properties;
        String key = this.getKeyText();
        List<PropertiesFile> propertiesFiles = this.getPropertiesFiles();
        if (propertiesFiles == null) {
            properties = PropertiesImplUtil.findPropertiesByKey(this.getElement().getProject(), key);
        } else {
            properties = new ArrayList();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                properties.addAll(propertiesFile.findPropertiesByKey(key));
            }
        }
        ContainerUtil.quickSort(properties, (o1, o2) -> {
            String name1 = o1.getPropertiesFile().getName();
            String name2 = o2.getPropertiesFile().getName();
            return Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
        });
        return PropertyReferenceBase.getResolveResults(properties);
    }

    private static ResolveResult @NotNull [] getResolveResults(List<? extends IProperty> properties) {
        if (properties.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            IProperty property = properties.get(i);
            results[i] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
        }
        return results;
    }

    @Nullable
    protected abstract List<PropertiesFile> getPropertiesFiles();

    private static boolean isProperty(PsiElement element) {
        if (element instanceof IProperty) {
            return true;
        }
        if (element instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)element).getTarget() instanceof XmlProperty;
        }
        if (element instanceof XmlTag && ((XmlTag)element).getName().equals("entry")) {
            return PropertiesImplUtil.isPropertiesFile(element.getContainingFile());
        }
        return false;
    }

    public static boolean isPropertyPsi(@NotNull PsiElement target) {
        return target instanceof IProperty || target instanceof PomTargetPsiElement && ((PomTargetPsiElement)target).getTarget() instanceof IProperty;
    }
}

