/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.projectView.ResourceBundleAwareNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleNode
extends ProjectViewNode<ResourceBundle>
implements ValidateableNode,
DropTargetNode,
ResourceBundleAwareNode {
    public ResourceBundleNode(@NotNull Project project, @NotNull ResourceBundle resourceBundle, ViewSettings settings) {
        super(project, (Object)resourceBundle, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        List<PropertiesFile> propertiesFiles = this.getResourceBundle().getPropertiesFiles();
        ArrayList children = new ArrayList();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            PsiFileNode node = new PsiFileNode(this.myProject, propertiesFile.getContainingFile(), this.getSettings());
            children.add((AbstractTreeNode<?>)node);
        }
        return children;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (!file.isValid()) {
            return false;
        }
        assert (this.myProject != null);
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile != null && this.getResourceBundle().getPropertiesFiles().contains(propertiesFile);
    }

    public VirtualFile getVirtualFile() {
        ResourceBundle rb = this.getResourceBundle();
        if (!rb.isValid()) {
            return null;
        }
        List<PropertiesFile> list = rb.getPropertiesFiles();
        if (!list.isEmpty()) {
            return list.get(0).getVirtualFile();
        }
        return null;
    }

    public void update(@NotNull PresentationData presentation) {
        presentation.setIcon(AllIcons.Nodes.ResourceBundle);
        ResourceBundle rb = this.getResourceBundle();
        if (rb.isValid()) {
            presentation.setPresentableText(PropertiesBundle.message("project.view.resource.bundle.tree.node.text", rb.getBaseName()));
        }
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        assert (this.myProject != null);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, (VirtualFile)new ResourceBundleAsVirtualFile(this.getResourceBundle()));
        FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, requestFocus);
    }

    public boolean isSortByFirstChild() {
        return true;
    }

    public Comparable getTypeSortKey() {
        return new PsiFileNode.ExtensionSortKey(PropertiesFileType.INSTANCE.getDefaultExtension());
    }

    public boolean validate() {
        ResourceBundle currentBundle;
        if (!super.validate()) {
            return false;
        }
        ResourceBundle newBundle = this.getResourceBundle().getDefaultPropertiesFile().getResourceBundle();
        if (!Comparing.equal((Object)newBundle, (Object)(currentBundle = this.getResourceBundle()))) {
            return false;
        }
        return currentBundle.isValid();
    }

    public boolean isValid() {
        return this.getResourceBundle().isValid();
    }

    public boolean canDrop(TreeNode @NotNull [] sourceNodes) {
        for (TreeNode node : sourceNodes) {
            if (ResourceBundleNode.extractPropertiesFileFromNode(node) != null) continue;
            return false;
        }
        return true;
    }

    public void drop(TreeNode @NotNull [] sourceNodes, @NotNull DataContext dataContext) {
        MultiMap bundleGrouping = new MultiMap();
        for (TreeNode sourceNode : sourceNodes) {
            PropertiesFile propertiesFile = ResourceBundleNode.extractPropertiesFileFromNode(sourceNode);
            if (propertiesFile == null) {
                return;
            }
            bundleGrouping.putValue((Object)propertiesFile.getResourceBundle(), (Object)propertiesFile);
        }
        ResourceBundle resourceBundle = this.getResourceBundle();
        bundleGrouping.remove((Object)resourceBundle);
        ResourceBundleManager resourceBundleManager = ResourceBundleManager.getInstance(this.myProject);
        ArrayList<PropertiesFile> toAddInResourceBundle = new ArrayList<PropertiesFile>();
        for (Map.Entry entry : bundleGrouping.entrySet()) {
            toAddInResourceBundle.addAll((Collection)entry.getValue());
            ResourceBundle currentBundle = (ResourceBundle)entry.getKey();
            Collection propertiesFilesToMove = (Collection)entry.getValue();
            if (currentBundle.getPropertiesFiles().size() - propertiesFilesToMove.size() <= 0) continue;
            String currentBundleBaseName = currentBundle.getBaseName();
            ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>(currentBundle.getPropertiesFiles());
            files.removeAll(propertiesFilesToMove);
            resourceBundleManager.dissociateResourceBundle(currentBundle);
            resourceBundleManager.combineToResourceBundle(files, currentBundleBaseName);
        }
        toAddInResourceBundle.addAll(resourceBundle.getPropertiesFiles());
        String baseName = resourceBundle.getBaseName();
        assert (this.myProject != null);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle));
        resourceBundleManager.dissociateResourceBundle(resourceBundle);
        ResourceBundle updatedBundle = resourceBundleManager.combineToResourceBundleAndGet(toAddInResourceBundle, baseName);
        FileEditorManager.getInstance((Project)this.myProject).openFile((VirtualFile)new ResourceBundleAsVirtualFile(updatedBundle), true);
        ProjectView.getInstance((Project)this.myProject).refresh();
    }

    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext) {
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        ResourceBundle rb = this.getResourceBundle();
        return rb.isValid() ? ContainerUtil.map(rb.getPropertiesFiles(), PropertiesFile::getVirtualFile) : Collections.emptyList();
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        return (ResourceBundle)Objects.requireNonNull(this.getValue());
    }

    @Nullable
    private static PropertiesFile extractPropertiesFileFromNode(TreeNode node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        if (!(userObject instanceof PsiFileNode)) {
            return null;
        }
        PsiFile file = (PsiFile)((PsiFileNode)userObject).getValue();
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
        if (propertiesFile == null || !file.getManager().isInProject((PsiElement)file) || !file.isValid()) {
            return null;
        }
        return propertiesFile;
    }
}

