/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.containers.ContainerUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Presentation(icon="AllIcons.Nodes.ResourceBundle")
public class ResourceBundleAsVirtualFile
extends VirtualFile
implements VirtualFileWithoutContent {
    private final ResourceBundle myResourceBundle;

    public ResourceBundleAsVirtualFile(@NotNull ResourceBundle resourceBundle) {
        this.myResourceBundle = resourceBundle;
    }

    @NotNull
    public ResourceBundle getResourceBundle() {
        return this.myResourceBundle;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return LocalFileSystem.getInstance();
    }

    @NotNull
    public String getPath() {
        return this.getName();
    }

    @NotNull
    public String getName() {
        return this.myResourceBundle.isValid() ? this.myResourceBundle.getBaseName() : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleAsVirtualFile resourceBundleAsVirtualFile = (ResourceBundleAsVirtualFile)((Object)o);
        return this.myResourceBundle.equals(resourceBundleAsVirtualFile.myResourceBundle);
    }

    public int hashCode() {
        return this.myResourceBundle.hashCode();
    }

    public void rename(Object requestor, @NotNull String newName) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        if (this.myResourceBundle instanceof ResourceBundleImpl && !this.myResourceBundle.isValid()) {
            return false;
        }
        for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles()) {
            VirtualFile virtualFile = propertiesFile.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) continue;
            return false;
        }
        return true;
    }

    public VirtualFile getParent() {
        return this.myResourceBundle.isValid() ? this.myResourceBundle.getBaseDirectory() : null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) {
        throw new UnsupportedOperationException();
    }

    public void delete(Object requestor) {
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) {
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() {
        return new byte[0];
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        List files = ContainerUtil.mapNotNull(this.myResourceBundle.getPropertiesFiles(), file -> file.getVirtualFile());
        if (!files.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, postRunnable, (Collection)files);
        }
    }
}

