/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unused;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedPropertyInspection
extends PropertiesInspectionBase {
    public static final String SHORT_NAME = "UnusedProperty";
    private static final Logger LOG = Logger.getInstance(UnusedPropertyInspection.class);

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Nullable
    private static GlobalSearchScope getWidestUseScope(@Nullable String key, @NotNull Project project, @NotNull Module ownModule) {
        if (key == null) {
            return null;
        }
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (IProperty property : PropertiesImplUtil.findPropertiesByKey(project, key)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property.getPsiElement());
            if (module == null) {
                return GlobalSearchScope.allScope((Project)project);
            }
            if (module == ownModule) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return null;
        }
        return GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])modules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiFile file = session.getFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return super.buildVisitor(holder, isOnTheFly, session);
        }
        final UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                if (UnusedPropertyInspection.isPropertyUsed(property, helper, isOnTheFly)) {
                    return;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createRemovePropertyLocalFix();
                holder.registerProblem((PsiElement)key, PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
            }
        };
    }

    public static boolean isPropertyUsed(@NotNull Property property, @NotNull UnusedPropertiesSearchHelper helper, boolean isOnTheFly) {
        ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        if (original != null) {
            if (original.isCanceled()) {
                return true;
            }
            original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
        }
        if (ImplicitPropertyUsageProvider.isImplicitlyUsed(property)) {
            return true;
        }
        String name = property.getName();
        if (name == null) {
            return true;
        }
        PsiSearchHelper searchHelper = helper.getSearchHelper();
        if (UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, helper.getOwnUseScope(), isOnTheFly, original)) {
            return true;
        }
        GlobalSearchScope widerScope = UnusedPropertyInspection.getWidestUseScope(property.getKey(), property.getProject(), helper.getModule());
        return widerScope != null && UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, widerScope, isOnTheFly, original);
    }

    private static boolean mayHaveUsages(@NotNull PsiElement property, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope, boolean onTheFly, @Nullable ProgressIndicator indicator) {
        GlobalSearchScope exceptPropertyFiles = UnusedPropertyInspection.createExceptPropertyFilesScope(searchScope);
        GlobalSearchScope newScope = searchScope.intersectWith(exceptPropertyFiles);
        PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, newScope, null, indicator);
        if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            return false;
        }
        if (onTheFly && cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return true;
        }
        return ReferencesSearch.search((PsiElement)property, (SearchScope)newScope, (boolean)false).findFirst() != null;
    }

    @NotNull
    private static GlobalSearchScope createExceptPropertyFilesScope(@NotNull GlobalSearchScope origin) {
        return new DelegatingGlobalSearchScope(origin){

            public boolean contains(@NotNull VirtualFile file) {
                return super.contains(file) && !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PropertiesFileType.INSTANCE);
            }
        };
    }

    public static class UnusedPropertiesSearchHelper {
        private final GlobalSearchScope myOwnUseScope;
        private final Module myModule;
        private final PsiSearchHelper mySearchHelper;

        public UnusedPropertiesSearchHelper(Module module) {
            this.myOwnUseScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
            this.myModule = module;
            this.mySearchHelper = PsiSearchHelper.getInstance((Project)module.getProject());
        }

        public Module getModule() {
            return this.myModule;
        }

        GlobalSearchScope getOwnUseScope() {
            return this.myOwnUseScope;
        }

        PsiSearchHelper getSearchHelper() {
            return this.mySearchHelper;
        }
    }
}

