/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.util.GUtil;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleLog;

public class GradleUtil {
    private static final String LAST_USED_GRADLE_HOME_KEY = "last.used.gradle.home";

    private GradleUtil() {
    }

    @NotNull
    public static FileChooserDescriptor getGradleProjectFileChooserDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(file -> SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle") || StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle.kts") : StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".gradle") || StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".gradle.kts"));
    }

    @NotNull
    public static FileChooserDescriptor getGradleHomeFileChooserDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
    }

    public static boolean isGradleDefaultWrapperFilesExist(@Nullable String gradleProjectPath) {
        return GradleUtil.getWrapperConfiguration(gradleProjectPath) != null;
    }

    @Nullable
    public static WrapperConfiguration getWrapperConfiguration(@Nullable String gradleProjectPath) {
        File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(gradleProjectPath);
        if (wrapperPropertiesFile == null) {
            return null;
        }
        WrapperConfiguration wrapperConfiguration = new WrapperConfiguration();
        try {
            String zipStoreBase;
            String zipStorePath;
            String distPathBase;
            Properties props = GUtil.loadProperties((File)wrapperPropertiesFile);
            String distributionUrl = props.getProperty("distributionUrl");
            if (StringUtil.isEmpty((String)distributionUrl)) {
                throw new ExternalSystemException("Wrapper 'distributionUrl' property does not exist!");
            }
            wrapperConfiguration.setDistribution(GradleUtil.prepareDistributionUri(distributionUrl, wrapperPropertiesFile));
            String distributionPath = props.getProperty("distributionPath");
            if (!StringUtil.isEmpty((String)distributionPath)) {
                wrapperConfiguration.setDistributionPath(distributionPath);
            }
            if (!StringUtil.isEmpty((String)(distPathBase = props.getProperty("distributionBase")))) {
                wrapperConfiguration.setDistributionBase(distPathBase);
            }
            if (!StringUtil.isEmpty((String)(zipStorePath = props.getProperty("zipStorePath")))) {
                wrapperConfiguration.setZipPath(zipStorePath);
            }
            if (!StringUtil.isEmpty((String)(zipStoreBase = props.getProperty("zipStoreBase")))) {
                wrapperConfiguration.setZipBase(zipStoreBase);
            }
            return wrapperConfiguration;
        }
        catch (Exception e) {
            GradleLog.LOG.warn(String.format("I/O exception on reading gradle wrapper properties file at '%s'", wrapperPropertiesFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    private static URI prepareDistributionUri(String distributionUrl, File propertiesFile) throws URISyntaxException {
        URI source = new URI(distributionUrl);
        return source.getScheme() != null ? source : new File(propertiesFile.getParentFile(), source.getSchemeSpecificPart()).toURI();
    }

    @NotNull
    public static String getConfigPath(@NotNull GradleProject subProject, @NotNull String rootProjectPath) {
        try {
            File file;
            GradleScript script = subProject.getBuildScript();
            if (script != null && (file = script.getSourceFile()) != null) {
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                return ExternalSystemApiUtil.toCanonicalPath((String)file.getCanonicalPath());
            }
        }
        catch (Exception script) {
            // empty catch block
        }
        File rootProjectParent = new File(rootProjectPath);
        StringBuilder buffer = new StringBuilder(FileUtil.toCanonicalPath((String)rootProjectParent.getAbsolutePath()));
        Stack stack = new Stack();
        for (GradleProject p = subProject; p != null; p = p.getParent()) {
            stack.push((Object)p.getName());
        }
        stack.pop();
        while (!stack.isEmpty()) {
            buffer.append('/').append((String)stack.pop());
        }
        return buffer.toString();
    }

    @NotNull
    public static String getLastUsedGradleHome() {
        return PropertiesComponent.getInstance().getValue(LAST_USED_GRADLE_HOME_KEY, "");
    }

    public static void storeLastUsedGradleHome(@Nullable String gradleHomePath) {
        PropertiesComponent.getInstance().setValue(LAST_USED_GRADLE_HOME_KEY, gradleHomePath, null);
    }

    @Nullable
    public static File findDefaultWrapperPropertiesFile(@Nullable String gradleProjectPath) {
        if (gradleProjectPath == null) {
            return null;
        }
        File file = new File(gradleProjectPath);
        File gradleDir = file.isFile() ? new File(file.getParentFile(), "gradle") : new File(file, "gradle");
        if (!gradleDir.isDirectory()) {
            return null;
        }
        File wrapperDir = new File(gradleDir, "wrapper");
        if (!wrapperDir.isDirectory()) {
            return null;
        }
        Object[] candidates = wrapperDir.listFiles(FileFilters.filesWithExtension((String)"properties"));
        if (candidates == null) {
            GradleLog.LOG.warn("No *.properties file is found at the gradle wrapper directory " + wrapperDir.getAbsolutePath());
            return null;
        }
        if (candidates.length != 1) {
            GradleLog.LOG.warn(String.format("%d *.properties files instead of one have been found at the wrapper directory (%s): %s", candidates.length, wrapperDir.getAbsolutePath(), Arrays.toString(candidates)));
            return null;
        }
        return candidates[0];
    }

    @NotNull
    public static String determineRootProject(@NotNull String subProjectPath) {
        Path subProject;
        try {
            for (Path candidate = subProject = Paths.get(subProjectPath, new String[0]); candidate != null && candidate != candidate.getParent(); candidate = candidate.getParent()) {
                if (!GradleUtil.containsGradleSettingsFile(candidate)) continue;
                return candidate.toString();
            }
        }
        catch (IOException e) {
            GradleLog.LOG.warn("Failed to determine root Gradle project directory for [" + subProjectPath + "]", (Throwable)e);
        }
        return Files.isDirectory(subProject, new LinkOption[0]) ? subProjectPath : subProject.getParent().toString();
    }

    private static boolean containsGradleSettingsFile(Path directory) throws IOException {
        return Files.isDirectory(directory, new LinkOption[0]) && Files.walk(directory, 1, new FileVisitOption[0]).map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).anyMatch(name -> name.startsWith("settings.gradle"));
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Module module) {
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            return null;
        }
        Project project = module.getProject();
        return GradleUtil.findGradleModuleData(project, projectPath);
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Project project, @NotNull String projectPath) {
        DataNode projectNode = ExternalSystemApiUtil.findProjectData((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (projectNode == null) {
            return null;
        }
        BooleanFunction predicate = node -> projectPath.equals(((ModuleData)node.getData()).getLinkedExternalProjectPath());
        return ExternalSystemApiUtil.find((DataNode)projectNode, (Key)ProjectKeys.MODULE, (BooleanFunction)predicate);
    }
}

