/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

public class GradleProjectSettings
extends ExternalProjectSettings {
    private static final Logger LOG = Logger.getInstance(GradleProjectSettings.class);
    public static final boolean DEFAULT_DELEGATE = true;
    public static final TestRunner DEFAULT_TEST_RUNNER = TestRunner.GRADLE;
    @Nullable
    private String myGradleHome;
    @Nullable
    private String myGradleJvm = "#USE_PROJECT_JDK";
    @Nullable
    private DistributionType distributionType;
    private boolean disableWrapperSourceDistributionNotification;
    private boolean resolveModulePerSourceSet = true;
    private boolean resolveExternalAnnotations = true;
    @Nullable
    private CompositeBuild myCompositeBuild;
    @Nullable
    private Boolean delegatedBuild;
    @Nullable
    private TestRunner testRunner;

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    public void setGradleHome(@Nullable String gradleHome) {
        this.myGradleHome = gradleHome;
    }

    @Nullable
    public String getGradleJvm() {
        return this.myGradleJvm;
    }

    public void setGradleJvm(@Nullable String gradleJvm) {
        this.myGradleJvm = gradleJvm;
    }

    @Nullable
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(@Nullable DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public boolean isDisableWrapperSourceDistributionNotification() {
        return this.disableWrapperSourceDistributionNotification;
    }

    public void setDisableWrapperSourceDistributionNotification(boolean disableWrapperSourceDistributionNotification) {
        this.disableWrapperSourceDistributionNotification = disableWrapperSourceDistributionNotification;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean useIdeModulePerSourceSet) {
        this.resolveModulePerSourceSet = useIdeModulePerSourceSet;
    }

    public boolean isResolveExternalAnnotations() {
        return this.resolveExternalAnnotations;
    }

    public void setResolveExternalAnnotations(boolean resolveExternalAnnotations) {
        this.resolveExternalAnnotations = resolveExternalAnnotations;
    }

    @OptionTag(tag="compositeConfiguration", nameAttribute="")
    @Nullable
    public CompositeBuild getCompositeBuild() {
        return this.myCompositeBuild;
    }

    public void setCompositeBuild(@Nullable CompositeBuild compositeBuild) {
        this.myCompositeBuild = compositeBuild;
    }

    @NotNull
    public GradleProjectSettings clone() {
        GradleProjectSettings result = new GradleProjectSettings();
        this.copyTo(result);
        result.myGradleHome = this.myGradleHome;
        result.myGradleJvm = this.myGradleJvm;
        result.distributionType = this.distributionType;
        result.disableWrapperSourceDistributionNotification = this.disableWrapperSourceDistributionNotification;
        result.resolveModulePerSourceSet = this.resolveModulePerSourceSet;
        result.resolveExternalAnnotations = this.resolveExternalAnnotations;
        result.myCompositeBuild = this.myCompositeBuild != null ? this.myCompositeBuild.copy() : null;
        result.delegatedBuild = this.delegatedBuild;
        result.testRunner = this.testRunner;
        return result;
    }

    @Deprecated
    public ThreeState getStoreProjectFilesExternally() {
        return ThreeState.UNSURE;
    }

    @Deprecated
    public void setStoreProjectFilesExternally(@NotNull ThreeState value) {
    }

    @Transient
    public boolean getDelegatedBuild() {
        return (Boolean)ObjectUtils.notNull((Object)this.delegatedBuild, (Object)true);
    }

    public void setDelegatedBuild(@NotNull Boolean state) {
        this.delegatedBuild = state;
    }

    @OptionTag(value="delegatedBuild")
    @Nullable
    public Boolean getDirectDelegatedBuild() {
        return this.delegatedBuild;
    }

    public void setDirectDelegatedBuild(@Nullable Boolean state) {
        this.delegatedBuild = state;
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Project project, @Nullable String gradleProjectPath) {
        GradleProjectSettings projectSettings;
        GradleProjectSettings gradleProjectSettings = projectSettings = gradleProjectPath == null ? null : (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(gradleProjectPath);
        if (projectSettings == null) {
            return false;
        }
        return projectSettings.getDelegatedBuild();
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Module module) {
        return GradleProjectSettings.isDelegatedBuildEnabled(module.getProject(), ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
    }

    @Transient
    @NotNull
    public TestRunner getTestRunner() {
        return (TestRunner)((Object)ObjectUtils.notNull((Object)((Object)this.testRunner), (Object)((Object)DEFAULT_TEST_RUNNER)));
    }

    public void setTestRunner(@NotNull TestRunner testRunner) {
        if (LOG.isDebugEnabled() && testRunner != TestRunner.GRADLE) {
            LOG.debug(String.format("Gradle test runner sets to %s", new Object[]{testRunner}), new Throwable());
        }
        this.testRunner = testRunner;
    }

    @OptionTag(value="testRunner")
    @Nullable
    public TestRunner getDirectTestRunner() {
        return this.testRunner;
    }

    public void setDirectTestRunner(@Nullable TestRunner testRunner) {
        this.testRunner = testRunner;
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Project project, @Nullable String gradleProjectPath) {
        TestRunner testRunner;
        GradleProjectSettings projectSettings = gradleProjectPath == null ? null : (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(gradleProjectPath);
        TestRunner testRunner2 = testRunner = projectSettings == null ? TestRunner.PLATFORM : projectSettings.getTestRunner();
        if (LOG.isDebugEnabled() && testRunner != TestRunner.GRADLE) {
            String settingsPresentation = projectSettings == null ? String.format("<null: %s>", gradleProjectPath) : gradleProjectPath;
            LOG.debug(String.format("Get non gradle test runner %s at '%s'", new Object[]{testRunner, settingsPresentation}), new Throwable());
        }
        return testRunner;
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Module module) {
        return GradleProjectSettings.getTestRunner(module.getProject(), ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
    }

    @NotNull
    public GradleVersion resolveGradleVersion() {
        GradleVersion version = GradleInstallationManager.getGradleVersion(this);
        return Optional.ofNullable(version).orElseGet(GradleVersion::current);
    }

    public GradleProjectSettings withQualifiedModuleNames() {
        this.setUseQualifiedModuleNames(true);
        return this;
    }

    @Tag(value="compositeBuild")
    public static class CompositeBuild {
        @Nullable
        private CompositeDefinitionSource myCompositeDefinitionSource;
        private List<BuildParticipant> myCompositeParticipants = new SmartList();

        @Attribute
        @Nullable
        public CompositeDefinitionSource getCompositeDefinitionSource() {
            return this.myCompositeDefinitionSource;
        }

        public void setCompositeDefinitionSource(@Nullable CompositeDefinitionSource compositeDefinitionSource) {
            this.myCompositeDefinitionSource = compositeDefinitionSource;
        }

        @XCollection(propertyElementName="builds", elementName="build")
        @NotNull
        public List<BuildParticipant> getCompositeParticipants() {
            return this.myCompositeParticipants;
        }

        public void setCompositeParticipants(List<? extends BuildParticipant> compositeParticipants) {
            this.myCompositeParticipants = compositeParticipants == null ? new SmartList() : new ArrayList<BuildParticipant>(compositeParticipants);
        }

        @NotNull
        public CompositeBuild copy() {
            CompositeBuild result = new CompositeBuild();
            result.myCompositeParticipants = new ArrayList<BuildParticipant>();
            for (BuildParticipant participant : this.myCompositeParticipants) {
                result.myCompositeParticipants.add(participant.copy());
            }
            result.myCompositeDefinitionSource = this.myCompositeDefinitionSource;
            return result;
        }
    }
}

