/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.google.gson.GsonBuilder;
import com.intellij.build.SyncViewManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleTaskManager
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    public static final Key<String> INIT_SCRIPT_PREFIX_KEY = Key.create((String)"INIT_SCRIPT_PREFIX_KEY");
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        List<String> tasks = taskNames.stream().flatMap(s -> ParametersListUtil.parse((String)s, (boolean)false, (boolean)true).stream()).collect(Collectors.toList());
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, tasks, projectPath, settings2, jvmParametersSetup, listener2)) continue;
                return;
            }
        }
        GradleExecutionSettings effectiveSettings = settings2 == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings2;
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        this.myCancellationMap.put(id, cancellationTokenSource);
        Function f = connection -> {
            try {
                GradleTaskManager.setupGradleScriptDebugging(effectiveSettings);
                GradleTaskManager.setupDebuggerDispatchPort(effectiveSettings);
                GradleTaskManager.appendInitScriptArgument(tasks, jvmParametersSetup, effectiveSettings);
                try {
                    for (GradleBuildParticipant buildParticipant : effectiveSettings.getExecutionWorkspace().getBuildParticipants()) {
                        effectiveSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
                    }
                    BuildLauncher launcher = this.myHelper.getBuildLauncher(id, (ProjectConnection)connection, effectiveSettings, listener2);
                    launcher.forTasks(ArrayUtil.toStringArray((Collection)tasks));
                    launcher.withCancellationToken(cancellationTokenSource.token());
                    launcher.run();
                }
                finally {
                    this.myCancellationMap.remove(id);
                }
                return null;
            }
            catch (RuntimeException e) {
                LOG.debug("Gradle build launcher error", (Throwable)e);
                BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, cancellationTokenSource);
                GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
                throw projectResolverChain.getUserFriendlyError(buildEnvironment, e, projectPath, null);
            }
        };
        if (effectiveSettings.getDistributionType() == DistributionType.WRAPPED) {
            this.myHelper.ensureInstalledWrapper(id, GradleUtil.determineRootProject(projectPath), effectiveSettings, listener2, cancellationTokenSource.token());
        }
        this.myHelper.execute(projectPath, effectiveSettings, id, listener2, cancellationTokenSource, f);
    }

    protected static boolean isGradleScriptDebug(@Nullable GradleExecutionSettings settings2) {
        return Optional.ofNullable(settings2).map(s -> (Boolean)s.getUserData(GradleRunConfiguration.DEBUG_FLAG_KEY)).orElse(false);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource = this.myCancellationMap.get(id);
        if (cancellationTokenSource != null) {
            cancellationTokenSource.cancel();
            return true;
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings effectiveSettings) {
        String initScript;
        ArrayList initScripts = new ArrayList();
        List extensions = GradleProjectResolverUtil.createProjectResolvers(null).collect(Collectors.toList());
        for (GradleProjectResolverExtension resolverExtension : extensions) {
            String resolverClassName = resolverExtension.getClass().getName();
            Consumer initScriptConsumer = script -> {
                if (StringUtil.isNotEmpty((String)script)) {
                    ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                }
            };
            HashMap<String, String> enhancementParameters = new HashMap<String, String>();
            enhancementParameters.put("JVM_PARAMETERS_SETUP", jvmParametersSetup);
            String isTestExecution = String.valueOf(Boolean.TRUE == effectiveSettings.getUserData(GradleConstants.RUN_TASK_AS_TEST));
            enhancementParameters.put("TEST_EXECUTION_EXPECTED", isTestExecution);
            Integer debugDispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
            if (debugDispatchPort != null) {
                enhancementParameters.put("DEBUG_DISPATCH_PORT", String.valueOf(debugDispatchPort));
                String debugOptions = (String)effectiveSettings.getUserData(GradleRunConfiguration.DEBUGGER_PARAMETERS_KEY);
                enhancementParameters.put("DEBUG_OPTIONS", debugOptions);
            }
            resolverExtension.enhanceTaskProcessing(taskNames, (Consumer<String>)initScriptConsumer, enhancementParameters);
        }
        if (!initScripts.isEmpty()) {
            try {
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join(initScripts, (String)SystemProperties.getLineSeparator()), "ijresolvers");
                effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
            }
            catch (IOException e) {
                ExternalSystemException systemException = new ExternalSystemException((Throwable)e);
                systemException.initCause((Throwable)e);
                throw systemException;
            }
        }
        if (StringUtil.isNotEmpty((String)(initScript = (String)effectiveSettings.getUserData(INIT_SCRIPT_KEY)))) {
            try {
                String initScriptPrefix = (String)effectiveSettings.getUserData(INIT_SCRIPT_PREFIX_KEY);
                initScriptPrefix = StringUtil.isEmpty((String)initScriptPrefix) ? "ijmiscinit" : FileUtil.sanitizeFileName((String)initScriptPrefix);
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(initScript, initScriptPrefix);
                effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
            }
            catch (IOException e) {
                ExternalSystemException externalSystemException = new ExternalSystemException((Throwable)e);
                externalSystemException.initCause((Throwable)e);
                throw externalSystemException;
            }
        }
    }

    public static void setupGradleScriptDebugging(@NotNull GradleExecutionSettings effectiveSettings) {
        Integer gradleScriptDebugPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.BUILD_PROCESS_DEBUGGER_PORT_KEY);
        if (GradleTaskManager.isGradleScriptDebug(effectiveSettings) && gradleScriptDebugPort != null && gradleScriptDebugPort > 0) {
            boolean isJdk9orLater = ExternalSystemJdkUtil.isJdk9orLater((String)effectiveSettings.getJavaHome());
            String jvmOpt = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + (isJdk9orLater ? "127.0.0.1:" : "") + gradleScriptDebugPort;
            effectiveSettings.withVmOption(jvmOpt);
        }
    }

    public static void setupDebuggerDispatchPort(@NotNull GradleExecutionSettings effectiveSettings) {
        Integer dispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
        if (dispatchPort != null) {
            effectiveSettings.withVmOption(String.format("-D%s=%d", "idea.debugger.dispatch.port", dispatchPort));
        }
    }

    public static void runCustomTask(@NotNull Project project, @NotNull String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath, @Nullable String taskConfiguration, @Nullable TaskCallback callback) {
        GradleTaskManager.runCustomTask(project, executionName, taskClass, projectPath, gradlePath, taskConfiguration, ProgressExecutionMode.IN_BACKGROUND_ASYNC, callback);
    }

    public static void runCustomTask(@NotNull Project project, @NotNull String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback) {
        String taskName = taskClass.getSimpleName();
        String paths = GradleExecutionHelper.getToolingExtensionsJarPaths(ContainerUtil.set((Object[])new Class[]{taskClass, GsonBuilder.class, ExternalSystemException.class}));
        String initScript = "initscript {\n  dependencies {\n    classpath files(" + paths + ")\n  }\n}\nallprojects {\n  afterEvaluate { project ->\n    if(project.path == '" + gradlePath + "') {\n        def overwrite = project.tasks.findByName('" + taskName + "') != null\n        project.tasks.create(name: '" + taskName + "', overwrite: overwrite, type: " + taskClass.getName() + ") {\n" + StringUtil.notNullize((String)taskConfiguration) + "\n        }\n    }\n  }\n}\n";
        UserDataHolderBase userData = new UserDataHolderBase();
        userData.putUserData(INIT_SCRIPT_KEY, (Object)initScript);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        String gradleVmOptions = GradleSettings.getInstance(project).getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExecutionName(executionName);
        settings2.setExternalProjectPath(projectPath);
        String taskPrefix = gradlePath.endsWith(":") ? gradlePath : gradlePath + ':';
        settings2.setTaskNames(Collections.singletonList(taskPrefix + taskName));
        settings2.setVmOptions(gradleVmOptions);
        settings2.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings2, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)callback, (ProgressExecutionMode)progressExecutionMode, (boolean)false, (UserDataHolderBase)userData);
    }
}

