/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.Project;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.BaseResolverExtension;
import org.jetbrains.plugins.gradle.service.project.BuildActionRunner;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleBuildSrcProjectsResolver;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.ModifiableGradleProjectModelImpl;
import org.jetbrains.plugins.gradle.service.project.ProjectModelContributor;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.ToolingModelsProviderImpl;
import org.jetbrains.plugins.gradle.service.project.TracedProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolver.class);
    @NotNull
    private final GradleExecutionHelper myHelper;
    private final GradleLibraryNamesMixer myLibraryNamesMixer = new GradleLibraryNamesMixer();
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = MultiMap.create();
    public static final Key<Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>>> RESOLVED_SOURCE_SETS = Key.create((String)"resolvedSourceSets");
    public static final Key<Map<String, Pair<String, ExternalSystemSourceType>>> MODULES_OUTPUTS = Key.create((String)"moduleOutputsMap");
    public static final Key<MultiMap<ExternalSystemSourceType, String>> GRADLE_OUTPUTS = Key.create((String)"gradleOutputs");
    public static final Key<Map<String, String>> CONFIGURATION_ARTIFACTS = Key.create((String)"gradleArtifactsMap");
    private static final Key<File> GRADLE_HOME_DIR = Key.create((String)"gradleHomeDir");

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(@NotNull GradleExecutionHelper helper) {
        this.myHelper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId syncTaskId, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings2, @Nullable ProjectResolverPolicy resolverPolicy, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        GradlePartialResolverPolicy gradleResolverPolicy = null;
        if (resolverPolicy != null) {
            if (resolverPolicy instanceof GradlePartialResolverPolicy) {
                gradleResolverPolicy = (GradlePartialResolverPolicy)resolverPolicy;
            } else {
                throw new ExternalSystemException("Unsupported project resolver policy: " + resolverPolicy.getClass().getName());
            }
        }
        if (isPreviewMode) {
            String projectName = new File(projectPath).getName();
            ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectPath, projectPath);
            DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
            String ideProjectPath = settings2 == null ? null : settings2.getIdeProjectPath();
            String mainModuleFileDirectoryPath = ideProjectPath == null ? projectPath : ideProjectPath;
            projectDataNode.createChild(ProjectKeys.MODULE, (Object)new ModuleData(projectName, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), projectName, mainModuleFileDirectoryPath, projectPath)).createChild(ProjectKeys.CONTENT_ROOT, (Object)new ContentRootData(GradleConstants.SYSTEM_ID, projectPath));
            return projectDataNode;
        }
        DefaultProjectResolverContext resolverContext = new DefaultProjectResolverContext(syncTaskId, projectPath, settings2, listener2, gradleResolverPolicy, false);
        CancellationTokenSource cancellationTokenSource = resolverContext.getCancellationTokenSource();
        this.myCancellationMap.putValue((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
        try {
            if (settings2 != null) {
                this.myHelper.ensureInstalledWrapper(syncTaskId, projectPath, settings2, listener2, cancellationTokenSource.token());
            }
            Predicate<GradleProjectResolverExtension> extensionsFilter = gradleResolverPolicy != null ? gradleResolverPolicy.getExtensionsFilter() : null;
            GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(resolverContext, extensionsFilter);
            DataNode<ProjectData> projectDataNode = this.myHelper.execute(projectPath, settings2, syncTaskId, listener2, cancellationTokenSource, this.getProjectDataFunction(resolverContext, projectResolverChain, false));
            File gradleUserHome = (File)resolverContext.getUserData(GRADLE_HOME_DIR);
            new GradleBuildSrcProjectsResolver(this, resolverContext, gradleUserHome, settings2, listener2, syncTaskId, projectResolverChain).discoverAndAppendTo(projectDataNode);
            DataNode<ProjectData> dataNode = projectDataNode;
            return dataNode;
        }
        finally {
            this.myCancellationMap.remove((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
        }
    }

    @NotNull
    Function<ProjectConnection, DataNode<ProjectData>> getProjectDataFunction(DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
        return new ProjectConnectionDataNodeFunction(resolverContext, projectResolverChain, isBuildSrcProject);
    }

    @NotNull
    GradleExecutionHelper getHelper() {
        return this.myHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        MultiMap<ExternalSystemTaskId, CancellationTokenSource> multiMap = this.myCancellationMap;
        synchronized (multiMap) {
            for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
                cancellationTokenSource.cancel();
            }
        }
        return true;
    }

    @NotNull
    private DataNode<ProjectData> doResolveProjectInfo(@NotNull DefaultProjectResolverContext resolverCtx, @NotNull GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) throws IllegalArgumentException, IllegalStateException {
        IdeaModule ideaModule;
        DataNode moduleDataNode;
        ProjectImportAction.AllModels allModels;
        PerformanceTrace performanceTrace = new PerformanceTrace();
        TracedProjectResolverExtension tracedResolverChain = new TracedProjectResolverExtension(projectResolverChain, performanceTrace);
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(resolverCtx);
        GradleVersion gradleVersion = null;
        boolean isCompositeBuildsSupported = false;
        if (buildEnvironment != null) {
            gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
            isCompositeBuildsSupported = gradleVersion.compareTo(GradleVersion.version((String)"3.1")) >= 0;
            resolverCtx.setBuildEnvironment(buildEnvironment);
        }
        boolean useCustomSerialization = Registry.is((String)"gradle.tooling.custom.serializer", (boolean)true);
        ProjectImportAction projectImportAction = new ProjectImportAction(resolverCtx.isPreviewMode(), isCompositeBuildsSupported, useCustomSerialization);
        GradleExecutionSettings executionSettings = resolverCtx.getSettings();
        if (executionSettings == null) {
            executionSettings = new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false);
        }
        GradleProjectResolver.configureExecutionArgumentsAndVmOptions(executionSettings, resolverCtx, isBuildSrcProject);
        HashSet toolingExtensionClasses = new HashSet();
        for (GradleProjectResolverExtension resolverExtension = tracedResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            resolverExtension.setProjectResolverContext(resolverCtx);
            resolverExtension.preImportCheck();
            projectImportAction.addTargetTypes(resolverExtension.getTargetTypes());
            try {
                ProjectImportModelProvider projectsLoadedModelProvider;
                ProjectImportModelProvider modelProvider = resolverExtension.getModelProvider();
                if (modelProvider != null) {
                    projectImportAction.addProjectImportModelProvider(modelProvider);
                }
                if ((projectsLoadedModelProvider = resolverExtension.getProjectsLoadedModelProvider()) != null) {
                    projectImportAction.addProjectImportModelProvider(projectsLoadedModelProvider, true);
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
            try {
                toolingExtensionClasses.addAll(resolverExtension.getToolingExtensionsClasses());
                continue;
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
        File initScript = GradleExecutionHelper.generateInitScript(isBuildSrcProject, toolingExtensionClasses);
        if (initScript != null) {
            executionSettings.withArguments(new String[]{"--init-script", initScript.getAbsolutePath()});
        }
        BuildActionRunner buildActionRunner = new BuildActionRunner(resolverCtx, projectImportAction, executionSettings, this.myHelper);
        resolverCtx.checkCancelled();
        long startTime = System.currentTimeMillis();
        CountDownLatch buildFinishWaiter = new CountDownLatch(1);
        try {
            allModels = buildActionRunner.fetchModels(models -> {
                for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
                    resolver.projectsLoaded((ModelsHolder<BuildModel, ProjectModel>)models);
                }
            }, exception -> {
                try {
                    for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
                        resolver.buildFinished((GradleConnectionException)exception);
                    }
                }
                finally {
                    buildFinishWaiter.countDown();
                }
            });
            performanceTrace.addTrace(allModels.getPerformanceTrace());
        }
        catch (Exception e) {
            try {
                buildFinishWaiter.countDown();
                throw e;
            }
            catch (Throwable throwable) {
                ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)buildFinishWaiter);
                long timeInMs = System.currentTimeMillis() - startTime;
                performanceTrace.logPerformance("Gradle data obtained", timeInMs);
                LOG.debug(String.format("Gradle data obtained in %d ms", timeInMs));
                throw throwable;
            }
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)buildFinishWaiter);
        long timeInMs = System.currentTimeMillis() - startTime;
        performanceTrace.logPerformance("Gradle data obtained", timeInMs);
        LOG.debug(String.format("Gradle data obtained in %d ms", timeInMs));
        resolverCtx.checkCancelled();
        if (useCustomSerialization) {
            assert (gradleVersion != null);
            allModels.initToolingSerializer(gradleVersion);
        }
        allModels.setBuildEnvironment(buildEnvironment);
        long startDataConversionTime = System.currentTimeMillis();
        GradleProjectResolver.extractExternalProjectModels(allModels, resolverCtx, useCustomSerialization);
        String projectName = allModels.getMainBuild().getName();
        ModifiableGradleProjectModelImpl modifiableGradleProjectModel = new ModifiableGradleProjectModelImpl(projectName, resolverCtx.getProjectPath());
        ToolingModelsProviderImpl modelsProvider = new ToolingModelsProviderImpl(allModels);
        ProjectModelContributor.EP_NAME.forEachExtensionSafe(extension -> {
            resolverCtx.checkCancelled();
            long starResolveTime = System.currentTimeMillis();
            extension.accept(modifiableGradleProjectModel, modelsProvider, resolverCtx);
            long resolveTimeInMs = System.currentTimeMillis() - starResolveTime;
            performanceTrace.logPerformance("Project model contributed by " + extension.getClass().getSimpleName(), resolveTimeInMs);
            LOG.debug(String.format("Project model contributed by `" + extension.getClass().getSimpleName() + "` in %d ms", resolveTimeInMs));
        });
        DataNode<ProjectData> projectDataNode = modifiableGradleProjectModel.buildDataNodeGraph();
        DataNode performanceTraceNode = new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)performanceTrace, projectDataNode);
        projectDataNode.addChild(performanceTraceNode);
        DomainObjectSet gradleModules = Collections.emptySet();
        IdeaProject ideaProject = (IdeaProject)allModels.getModel(IdeaProject.class);
        if (ideaProject != null) {
            tracedResolverChain.populateProjectExtraModels(ideaProject, projectDataNode);
            gradleModules = ideaProject.getModules();
            if (gradleModules == null || gradleModules.isEmpty()) {
                throw new IllegalStateException("No modules found for the target project: " + ideaProject);
            }
        }
        Collection<IdeaModule> includedModules = GradleProjectResolver.exposeCompositeBuild(allModels, resolverCtx, projectDataNode);
        HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap = new HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>>();
        HashMap sourceSetsMap = new HashMap();
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, sourceSetsMap);
        THashMap moduleOutputsMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        projectDataNode.putUserData(MODULES_OUTPUTS, (Object)moduleOutputsMap);
        THashMap artifactsMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        projectDataNode.putUserData(CONFIGURATION_ARTIFACTS, (Object)artifactsMap);
        for (Object gradleModule : ContainerUtil.concat((Iterable)gradleModules, includedModules)) {
            String moduleName;
            if (gradleModule == null) continue;
            resolverCtx.checkCancelled();
            if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
                LOG.info(String.format("Importing module data: %s", gradleModule));
            }
            if ((moduleName = gradleModule.getName()) == null) {
                throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
            }
            moduleDataNode = tracedResolverChain.createModule((IdeaModule)gradleModule, projectDataNode);
            if (moduleDataNode == null) continue;
            String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, (IdeaModule)gradleModule);
            if (moduleMap.containsKey(mainModuleId)) {
                throw new IllegalStateException("Duplicate modules names detected: " + gradleModule);
            }
            moduleMap.put(mainModuleId, (Pair<DataNode<ModuleData>, IdeaModule>)Pair.create((Object)moduleDataNode, (Object)gradleModule));
        }
        executionSettings.getExecutionWorkspace().setModuleIdIndex(moduleMap);
        File gradleHomeDir = null;
        for (Pair pair : moduleMap.values()) {
            BuildScriptClasspathModel buildScriptClasspathModel;
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            if (gradleHomeDir == null && (buildScriptClasspathModel = resolverCtx.getExtraProject(ideaModule, BuildScriptClasspathModel.class)) != null) {
                gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
            }
            tracedResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            tracedResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            if (!isBuildSrcProject) {
                tracedResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, projectDataNode);
            }
            SmartList modules = new SmartList();
            modules.add(moduleDataNode);
            modules.addAll(ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY));
            ExternalSystemSourceType[] sourceTypes = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_RESOURCE};
            for (DataNode module : modules) {
                ModuleData moduleData = (ModuleData)module.getData();
                for (ExternalSystemSourceType sourceType : sourceTypes) {
                    String path = moduleData.getCompileOutputPath(sourceType);
                    if (path == null) continue;
                    moduleOutputsMap.put(path, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                }
                if (!(moduleData instanceof GradleSourceSetData)) continue;
                for (File artifactFile : moduleData.getArtifacts()) {
                    artifactsMap.put(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getAbsolutePath()), moduleData.getId());
                }
            }
        }
        resolverCtx.putUserData(GRADLE_HOME_DIR, gradleHomeDir);
        for (Pair pair : moduleMap.values()) {
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            tracedResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, projectDataNode);
            tracedResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
        }
        GradleProjectResolver.mergeSourceSetContentRoots(moduleMap, resolverCtx);
        if (resolverCtx.isResolveModulePerSourceSet()) {
            GradleProjectResolver.mergeLibraryAndModuleDependencyData(resolverCtx, projectDataNode, resolverCtx.getGradleUserHome(), gradleHomeDir, gradleVersion);
        }
        for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
            resolver.resolveFinished(projectDataNode);
        }
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, null);
        projectDataNode.putUserData(MODULES_OUTPUTS, null);
        projectDataNode.putUserData(CONFIGURATION_ARTIFACTS, null);
        Collection libraries = ExternalSystemApiUtil.getChildren(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        long timeConversionInMs = System.currentTimeMillis() - startDataConversionTime;
        performanceTrace.logPerformance("Gradle project data processed", timeConversionInMs);
        LOG.debug(String.format("Project data resolved in %d ms", timeConversionInMs));
        return projectDataNode;
    }

    private static void configureExecutionArgumentsAndVmOptions(@NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverCtx, boolean isBuildSrcProject) {
        executionSettings.withArgument("-Didea.sync.active=true");
        if (resolverCtx.isResolveModulePerSourceSet()) {
            executionSettings.withArgument("-Didea.resolveSourceSetDependencies=true");
        }
        if (!isBuildSrcProject) {
            for (GradleBuildParticipant buildParticipant : executionSettings.getExecutionWorkspace().getBuildParticipants()) {
                executionSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
        }
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        GradleProjectResolverUtil.createProjectResolvers(resolverCtx).forEachOrdered(extension -> {
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                ParametersList parametersList = new ParametersList();
                for (Pair<String, String> jvmArg : extension.getExtraJvmArgs()) {
                    parametersList.addProperty((String)jvmArg.first, (String)jvmArg.second);
                }
                executionSettings.withVmOptions(parametersList.getParameters());
            }
            executionSettings.withArguments(extension.getExtraCommandLineArgs());
        });
    }

    @NotNull
    private static Collection<IdeaModule> exposeCompositeBuild(ProjectImportAction.AllModels allModels, DefaultProjectResolverContext resolverCtx, DataNode<ProjectData> projectDataNode) {
        if (resolverCtx.getSettings() != null && !resolverCtx.getSettings().getExecutionWorkspace().getBuildParticipants().isEmpty()) {
            return Collections.emptyList();
        }
        SmartList gradleIncludedModules = new SmartList();
        List includedBuilds = allModels.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            ProjectData projectData = (ProjectData)projectDataNode.getData();
            CompositeBuildData compositeBuildData = new CompositeBuildData(projectData.getLinkedExternalProjectPath());
            for (Build build : includedBuilds) {
                if (build.getProjects().isEmpty()) continue;
                IdeaProject ideaProject = (IdeaProject)allModels.getModel((BuildModel)build, IdeaProject.class);
                if (ideaProject != null) {
                    gradleIncludedModules.addAll(ideaProject.getModules());
                }
                String rootProjectName = build.getName();
                BuildParticipant buildParticipant = new BuildParticipant();
                try {
                    String projectPath = ExternalSystemApiUtil.toCanonicalPath((String)build.getBuildIdentifier().getRootDir().getCanonicalPath());
                    buildParticipant.setRootProjectName(rootProjectName);
                    buildParticipant.setRootPath(projectPath);
                    if (ideaProject != null) {
                        for (IdeaModule module : ideaProject.getModules()) {
                            try {
                                String modulePath = ExternalSystemApiUtil.toCanonicalPath((String)module.getGradleProject().getProjectDirectory().getCanonicalPath());
                                buildParticipant.getProjects().add(modulePath);
                            }
                            catch (IOException e) {
                                LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
                            }
                        }
                    }
                    compositeBuildData.getCompositeParticipants().add(buildParticipant);
                }
                catch (IOException e) {
                    LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
                }
            }
            projectDataNode.createChild(CompositeBuildData.KEY, (Object)compositeBuildData);
        }
        return gradleIncludedModules;
    }

    private static void mergeLibraryAndModuleDependencyData(@NotNull ProjectResolverContext context, @NotNull DataNode<ProjectData> projectDataNode, @NotNull File gradleUserHomeDir, @Nullable File gradleHomeDir, @Nullable GradleVersion gradleVersion) {
        Map sourceSetMap = (Map)projectDataNode.getUserData(RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map moduleOutputsMap = (Map)projectDataNode.getUserData(MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        Map artifactsMap = (Map)projectDataNode.getUserData(CONFIGURATION_ARTIFACTS);
        assert (artifactsMap != null);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(context, gradleUserHomeDir, gradleHomeDir, gradleVersion, sourceSetMap, moduleOutputsMap, artifactsMap);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run((DataNode<LibraryDependencyData>)libraryDependencyDataNode);
        }
    }

    private static void extractExternalProjectModels(@NotNull ProjectImportAction.AllModels models, @NotNull ProjectResolverContext resolverCtx, boolean useCustomSerialization) {
        resolverCtx.setModels(models);
        Class modelClazz = resolverCtx.isPreviewMode() ? ExternalProjectPreview.class : ExternalProject.class;
        ExternalProject externalRootProject = (ExternalProject)models.getModel(modelClazz);
        if (externalRootProject == null) {
            return;
        }
        DefaultExternalProject wrappedExternalRootProject = useCustomSerialization ? (DefaultExternalProject)externalRootProject : new DefaultExternalProject(externalRootProject);
        models.addModel((Object)wrappedExternalRootProject, ExternalProject.class);
        Map<String, DefaultExternalProject> externalProjectsMap = GradleProjectResolver.createExternalProjectsMap(wrappedExternalRootProject);
        Collection projects2 = models.getMainBuild().getProjects();
        for (Project project : projects2) {
            ExternalProject externalProject = (ExternalProject)externalProjectsMap.get(project.getProjectIdentifier().getProjectPath());
            if (externalProject == null) continue;
            models.addModel((Object)externalProject, ExternalProject.class, (ProjectModel)project);
        }
        for (Build includedBuild : models.getIncludedBuilds()) {
            ExternalProject externalIncludedRootProject = (ExternalProject)models.getModel((BuildModel)includedBuild, modelClazz);
            if (externalIncludedRootProject == null) continue;
            DefaultExternalProject wrappedExternalIncludedRootProject = useCustomSerialization ? (DefaultExternalProject)externalIncludedRootProject : new DefaultExternalProject(externalIncludedRootProject);
            wrappedExternalRootProject.getChildProjects().put(wrappedExternalIncludedRootProject.getName(), wrappedExternalIncludedRootProject);
            Map<String, DefaultExternalProject> externalIncludedProjectsMap = GradleProjectResolver.createExternalProjectsMap(wrappedExternalIncludedRootProject);
            for (ProjectModel project : includedBuild.getProjects()) {
                ExternalProject externalProject = (ExternalProject)externalIncludedProjectsMap.get(project.getProjectIdentifier().getProjectPath());
                if (externalProject == null) continue;
                models.addModel((Object)externalProject, ExternalProject.class, project);
            }
        }
    }

    @NotNull
    private static Map<String, DefaultExternalProject> createExternalProjectsMap(@Nullable DefaultExternalProject rootExternalProject) {
        DefaultExternalProject externalProject;
        THashMap externalProjectMap = new THashMap();
        if (rootExternalProject == null) {
            return externalProjectMap;
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(rootExternalProject);
        while ((externalProject = (DefaultExternalProject)queue.pollFirst()) != null) {
            queue.addAll(externalProject.getChildProjects().values());
            externalProjectMap.put(externalProject.getQName(), externalProject);
        }
        return externalProjectMap;
    }

    private static void mergeSourceSetContentRoots(@NotNull Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap, @NotNull ProjectResolverContext resolverCtx) {
        DataNode moduleNode;
        Factory counterFactory = () -> new Counter();
        HashMap<String, Counter> weightMap = new HashMap<String, Counter>();
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                    ((Counter)ContainerUtil.getOrCreate(weightMap, (Object)file.getPath(), (Factory)counterFactory)).increment();
                }
            }
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                HashSet<String> set = new HashSet<String>();
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                        set.add(file.getPath());
                    }
                }
                for (String path : set) {
                    ((Counter)ContainerUtil.getOrCreate(weightMap, (Object)path, (Factory)counterFactory)).increment();
                }
            }
        }
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            ExternalProject externalProject = resolverCtx.getExtraProject((IdeaModule)pair.second, ExternalProject.class);
            if (externalProject == null) continue;
            if (resolverCtx.isResolveModulePerSourceSet()) {
                for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)sourceSetNode);
                }
                continue;
            }
            GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)moduleNode);
        }
    }

    private static void mergeModuleContentRoots(@NotNull Map<String, Counter> weightMap, @NotNull ExternalProject externalProject, @NotNull DataNode<? extends ModuleData> moduleNode) {
        File buildDir = externalProject.getBuildDir();
        MultiMap sourceSetRoots = MultiMap.create();
        Collection contentRootNodes = ExternalSystemApiUtil.findAll(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootNodes.size() <= 1) {
            return;
        }
        for (DataNode contentRootNode : contentRootNodes) {
            File root = new File(((ContentRootData)contentRootNode.getData()).getRootPath());
            if (FileUtil.isAncestor((File)buildDir, (File)root, (boolean)true)) continue;
            while (weightMap.containsKey(root.getParent()) && weightMap.get((Object)root.getParent()).count <= 1) {
                root = root.getParentFile();
            }
            ContentRootData mergedContentRoot = null;
            String rootPath = ExternalSystemApiUtil.toCanonicalPath((String)root.getAbsolutePath());
            HashSet paths = new HashSet(sourceSetRoots.keySet());
            for (String path : paths) {
                if (FileUtil.isAncestor((String)rootPath, (String)path, (boolean)true)) {
                    Collection values = sourceSetRoots.remove((Object)path);
                    if (values != null) {
                        sourceSetRoots.putValues((Object)rootPath, values);
                    }
                } else if (FileUtil.isAncestor((String)path, (String)rootPath, (boolean)false)) {
                    Collection contentRoots = sourceSetRoots.get((Object)path);
                    for (ContentRootData rootData : contentRoots) {
                        if (!StringUtil.equals((CharSequence)rootData.getRootPath(), (CharSequence)path)) continue;
                        mergedContentRoot = rootData;
                        break;
                    }
                    if (mergedContentRoot != null) break;
                    mergedContentRoot = (ContentRootData)contentRoots.iterator().next();
                    break;
                }
                if (sourceSetRoots.size() != 1) continue;
                break;
            }
            if (mergedContentRoot == null) {
                mergedContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, root.getAbsolutePath());
                sourceSetRoots.putValue((Object)mergedContentRoot.getRootPath(), (Object)mergedContentRoot);
            }
            for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                ContentRootData rootData;
                rootData = ((ContentRootData)contentRootNode.getData()).getPaths(externalSystemSourceType).iterator();
                while (rootData.hasNext()) {
                    ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)rootData.next();
                    mergedContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                }
            }
            contentRootNode.clear(true);
        }
        for (Map.Entry entry : sourceSetRoots.entrySet()) {
            String rootPath = (String)entry.getKey();
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootPath);
            for (ContentRootData rootData : (Collection)entry.getValue()) {
                for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                    Collection roots = rootData.getPaths(externalSystemSourceType);
                    for (ContentRootData.SourceRoot sourceRoot : roots) {
                        ideContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                    }
                }
            }
            moduleNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    @ApiStatus.Experimental
    public static GradleProjectResolverExtension createProjectResolverChain() {
        return GradleProjectResolver.createProjectResolverChain(null, null);
    }

    @NotNull
    private static GradleProjectResolverExtension createProjectResolverChain(@Nullable DefaultProjectResolverContext resolverContext, @Nullable Predicate<? super GradleProjectResolverExtension> extensionsFilter) {
        GradleProjectResolverExtension firstResolver;
        Stream<Object> extensions = GradleProjectResolverUtil.createProjectResolvers(resolverContext);
        if (extensionsFilter != null) {
            extensions = extensions.filter(extensionsFilter.or(BaseResolverExtension.class::isInstance));
        }
        ArrayDeque deque = new ArrayDeque();
        extensions.forEachOrdered(extension -> {
            GradleProjectResolverExtension previous = (GradleProjectResolverExtension)deque.peekLast();
            if (previous != null) {
                previous.setNext((GradleProjectResolverExtension)extension);
                if (previous.getNext() != extension) {
                    throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                }
            }
            deque.add(extension);
        });
        GradleProjectResolverExtension resolverExtension = firstResolver = (GradleProjectResolverExtension)deque.peekFirst();
        assert (resolverExtension != null);
        while (resolverExtension.getNext() != null) {
            resolverExtension = resolverExtension.getNext();
        }
        if (!(resolverExtension instanceof BaseResolverExtension)) {
            throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
        }
        AbstractProjectResolverExtension chainWrapper = new AbstractProjectResolverExtension(){

            @Override
            @NotNull
            public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
                ExternalSystemException friendlyError = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
                return new BaseProjectImportErrorHandler().checkErrorsWithoutQuickFixes(buildEnvironment, error, projectPath, buildFilePath, friendlyError);
            }
        };
        chainWrapper.setNext(firstResolver);
        return chainWrapper;
    }

    private class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        @NotNull
        private final GradleProjectResolverExtension myProjectResolverChain;
        private final boolean myIsBuildSrcProject;
        private final DefaultProjectResolverContext myResolverContext;

        private ProjectConnectionDataNodeFunction(@NotNull DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
            this.myResolverContext = resolverContext;
            this.myProjectResolverChain = projectResolverChain;
            this.myIsBuildSrcProject = isBuildSrcProject;
        }

        public DataNode<ProjectData> fun(ProjectConnection connection) {
            try {
                GradleProjectResolver.this.myCancellationMap.putValue((Object)this.myResolverContext.getExternalSystemTaskId(), (Object)this.myResolverContext.getCancellationTokenSource());
                this.myResolverContext.setConnection(connection);
                DataNode dataNode = GradleProjectResolver.this.doResolveProjectInfo(this.myResolverContext, this.myProjectResolverChain, this.myIsBuildSrcProject);
                return dataNode;
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                ExternalSystemException esException = (ExternalSystemException)((Object)ExceptionUtil.findCause((Throwable)e, ExternalSystemException.class));
                if (esException != null && esException != e) {
                    LOG.info("\nCaused by: " + esException.getOriginalReason());
                }
                throw this.myProjectResolverChain.getUserFriendlyError(this.myResolverContext.getBuildEnvironment(), e, this.myResolverContext.getProjectPath(), null);
            }
            finally {
                GradleProjectResolver.this.myCancellationMap.remove((Object)this.myResolverContext.getExternalSystemTaskId(), (Object)this.myResolverContext.getCancellationTokenSource());
            }
        }
    }

    private static class Counter {
        int count;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }
}

