/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class OpenGradleSettingsCallback
extends NotificationListener.Adapter {
    public static final String ID = "open_gradle_settings";
    private final Project myProject;

    public OpenGradleSettingsCallback(Project project) {
        this.myProject = project;
    }

    protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager instanceof GradleManager);
        GradleManager gradleManager = (GradleManager)manager;
        Configurable configurable = gradleManager.getConfigurable(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, configurable);
    }
}

