/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SkippedResult;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProgressEventConverter {
    static EventId getEventId(@NotNull ProgressEvent event, @NotNull String operationId) {
        String eventId;
        OperationDescriptor descriptor = event.getDescriptor();
        InternalOperationDescriptor internalDescriptor = descriptor instanceof DefaultOperationDescriptor ? ((DefaultOperationDescriptor)descriptor).getInternalOperationDescriptor() : null;
        String string = eventId = internalDescriptor == null ? operationId + descriptor.getDisplayName() : operationId + internalDescriptor.getId().toString();
        String parentEventId = descriptor.getParent() == null ? null : (internalDescriptor == null ? operationId + descriptor.getParent().getDisplayName() : operationId + internalDescriptor.getParentId().toString());
        return new EventId(eventId, parentEventId);
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(@NotNull ExternalSystemTaskId id, @NotNull ProgressEvent event, @NotNull String operationId) {
        return GradleProgressEventConverter.convert(id, event, GradleProgressEventConverter.getEventId(event, operationId));
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(@NotNull ExternalSystemTaskId id, @NotNull ProgressEvent event, @NotNull EventId eventId) {
        String description = event.getDescriptor().getName();
        if (event instanceof StartEvent) {
            return new ExternalSystemBuildEvent(id, (BuildEvent)new StartEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description));
        }
        if (event instanceof StatusEvent) {
            StatusEvent statusEvent = (StatusEvent)event;
            return new ExternalSystemBuildEvent(id, (BuildEvent)new ProgressBuildEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description, statusEvent.getTotal(), statusEvent.getProgress(), statusEvent.getUnit()));
        }
        if (event instanceof FinishEvent) {
            return new ExternalSystemBuildEvent(id, (BuildEvent)new FinishEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description, GradleProgressEventConverter.convert(((FinishEvent)event).getResult())));
        }
        if (event instanceof TaskProgressEvent) {
            return new ExternalSystemBuildEvent(id, (BuildEvent)new ProgressBuildEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description, -1L, -1L, ""));
        }
        return new ExternalSystemTaskNotificationEvent(id, description);
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(ExternalSystemTaskId id, ProgressEvent event) {
        return GradleProgressEventConverter.convert(id, event, "");
    }

    @NotNull
    private static EventResult convert(OperationResult operationResult) {
        if (operationResult instanceof FailureResult) {
            return new FailureResultImpl(null, null);
        }
        if (operationResult instanceof SkippedResult) {
            return new SkippedResultImpl();
        }
        boolean isUpToDate = operationResult instanceof TaskSuccessResult && ((TaskSuccessResult)operationResult).isUpToDate();
        return new SuccessResultImpl(isUpToDate);
    }

    @Nullable
    static ExternalSystemTaskNotificationEvent createProgressBuildEvent(@NotNull ExternalSystemTaskId taskId, @NotNull Object id, @NotNull ProgressEvent event) {
        long total = -1L;
        long progress = -1L;
        String unit = "";
        String operationName = event.getDescriptor().getName();
        if (operationName.startsWith("Download ")) {
            String path = operationName.substring("Download ".length());
            operationName = "Download " + GradleProgressEventConverter.getFileName(path);
        } else if (event instanceof TaskProgressEvent) {
            operationName = "Run tasks";
        } else if (event instanceof TestProgressEvent) {
            operationName = "Run tests";
        } else if (event.getDisplayName().startsWith("Configure project ") || event.getDisplayName().startsWith("Cross-configure project ")) {
            operationName = "Configure projects";
        } else {
            return null;
        }
        if (event instanceof StatusEvent) {
            total = ((StatusEvent)event).getTotal();
            progress = ((StatusEvent)event).getProgress();
            unit = ((StatusEvent)event).getUnit();
        }
        return new ExternalSystemBuildEvent(taskId, (BuildEvent)new ProgressBuildEventImpl(id, null, event.getEventTime(), operationName + "...", total, progress, unit));
    }

    @Nullable
    static ExternalSystemTaskNotificationEvent legacyCreateProgressBuildEvent(@NotNull ExternalSystemTaskId taskId, @NotNull Object id, @NotNull String event) {
        long total = -1L;
        long progress = -1L;
        String unit = "";
        String operationName = event;
        if (operationName.startsWith("Download ")) {
            String path = operationName.substring("Download ".length());
            operationName = "Download " + GradleProgressEventConverter.getFileName(path);
        } else if (operationName.startsWith("Task: ")) {
            operationName = "Run tasks";
        } else if (operationName.equals("Build")) {
            operationName = "Build";
        } else if (operationName.startsWith("Build model ") || operationName.startsWith("Build parameterized model")) {
            operationName = "Build model";
        } else if (operationName.startsWith("Configure project ") || operationName.startsWith("Cross-configure project ")) {
            operationName = "Configure projects";
        } else {
            return null;
        }
        return new ExternalSystemBuildEvent(taskId, (BuildEvent)new ProgressBuildEventImpl(id, null, 0L, operationName + "...", total, progress, unit));
    }

    @NotNull
    private static String getFileName(String path) {
        String fileName;
        int index = path.lastIndexOf(47);
        if (index > 0 && index < path.length() && !(fileName = path.substring(index + 1)).isEmpty()) {
            return fileName;
        }
        return path;
    }

    static class EventId {
        Object id;
        Object parentId;

        EventId(Object id, Object parentId) {
            this.id = id;
            this.parentId = parentId;
        }
    }
}

