/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class WarDirectory
implements Serializable {
    public static final WarDirectory WAR_ROOT = new WarDirectory("/");
    public static final WarDirectory META_INF = new WarDirectory("/META-INF");
    public static final WarDirectory WEB_INF = new WarDirectory("/WEB-INF");
    public static final WarDirectory WEB_INF_LIB = new WarDirectory("/WEB-INF/lib");
    public static final WarDirectory WEB_INF_LIB_PROVIDED = new WarDirectory("/WEB-INF/lib-provided");
    public static final WarDirectory WEB_INF_CLASSES = new WarDirectory("/WEB-INF/classes");
    private static final WarDirectory[] WAR_DIRECTORIES = new WarDirectory[]{WAR_ROOT, META_INF, WEB_INF, WEB_INF_LIB, WEB_INF_LIB_PROVIDED, WEB_INF_CLASSES};
    @NotNull
    private final String relativePath;

    @PropertyMapping(value={"relativePath"})
    WarDirectory(@NotNull String relativePath) {
        this.relativePath = WarDirectory.getAdjustedPath(relativePath);
    }

    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean isCustomDirectory() {
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!this.relativePath.equals(warDirectory.getRelativePath())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static WarDirectory fromPath(@NotNull String path) {
        if (StringUtil.isEmpty((String)path)) {
            return WAR_ROOT;
        }
        String adjustedPath = WarDirectory.getAdjustedPath(path);
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!warDirectory.relativePath.equals(adjustedPath)) continue;
            return warDirectory;
        }
        return new WarDirectory(adjustedPath);
    }

    private static String getAdjustedPath(@NotNull String path) {
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public String toString() {
        return this.relativePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarDirectory directory = (WarDirectory)o;
        return this.relativePath.equals(directory.relativePath);
    }

    public int hashCode() {
        return this.relativePath.hashCode();
    }
}

