/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class CachedModuleDataFinder {
    private final Map<String, DataNode<? extends ModuleData>> cache = new HashMap<String, DataNode<? extends ModuleData>>();

    @Nullable
    public DataNode<? extends ModuleData> findModuleData(DataNode<ProjectData> projectNode, String projectPath) {
        DataNode<? extends ModuleData> cachedNode = this.cache.get(projectPath);
        if (cachedNode != null) {
            return cachedNode;
        }
        return ExternalSystemApiUtil.find(projectNode, (Key)ProjectKeys.MODULE, node -> {
            String externalProjectPath = ((ModuleData)node.getData()).getLinkedExternalProjectPath();
            this.cache.put(externalProjectPath, (DataNode<? extends ModuleData>)node);
            return StringUtil.equals((CharSequence)projectPath, (CharSequence)((ModuleData)node.getData()).getLinkedExternalProjectPath());
        });
    }

    @Nullable
    public DataNode<? extends ModuleData> findModuleData(@NotNull Module module) {
        DataNode<? extends ModuleData> mainModuleData = this.findMainModuleData(module);
        if (mainModuleData == null) {
            return null;
        }
        boolean isSourceSet = "sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module));
        if (!isSourceSet) {
            return mainModuleData;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        DataNode<? extends ModuleData> cachedNode = this.cache.get(projectId);
        if (cachedNode != null) {
            return cachedNode;
        }
        return ExternalSystemApiUtil.find(mainModuleData, GradleSourceSetData.KEY, node -> {
            String id = ((GradleSourceSetData)((Object)((Object)node.getData()))).getId();
            this.cache.put(id, (DataNode<? extends ModuleData>)node);
            return StringUtil.equals((CharSequence)projectId, (CharSequence)id);
        });
    }

    @Nullable
    public DataNode<? extends ModuleData> findMainModuleData(@NotNull Module module) {
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath == null) {
            return null;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (projectId == null) {
            return null;
        }
        String externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (externalProjectPath == null || StringUtil.endsWith((CharSequence)externalProjectPath, (CharSequence)"buildSrc")) {
            return null;
        }
        ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(module.getProject(), GradleConstants.SYSTEM_ID, rootProjectPath);
        if (projectData == null) {
            return null;
        }
        DataNode projectStructure = projectData.getExternalProjectStructure();
        if (projectStructure == null) {
            return null;
        }
        return this.findModuleData((DataNode<ProjectData>)projectStructure, externalProjectPath);
    }
}

