/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServices;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.DistributionFactoryExt;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.loader.rt.MarkerRt;

@Service
@ApiStatus.Internal
public final class GradleConnectorService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GradleConnectorService.class);
    private static final boolean DISABLE_STOP_OLD_IDLE_DAEMONS = Boolean.getBoolean("idea.gradle.disableStopIdleDaemonsOnProjectClose");
    private static final Set<String> REPORTED_JAVA11_ISSUE = ContainerUtil.newConcurrentSet();
    private final ConcurrentHashMap<String, GradleProjectConnection> connectorsMap = new ConcurrentHashMap();

    public void dispose() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.disconnectGradleConnections();
        this.stopIdleDaemonsOfOldVersions();
    }

    private void stopIdleDaemonsOfOldVersions() {
        if (DISABLE_STOP_OLD_IDLE_DAEMONS) {
            return;
        }
        try {
            if (ProjectUtil.getOpenProjects().length == 0) {
                GradleVersion gradleVersion_6_5 = GradleVersion.version((String)"6.5");
                List idleDaemons = ContainerUtil.filter(GradleDaemonServices.getDaemonsStatus(), daemonState -> daemonState.getStatus().toLowerCase() == "idle" && GradleVersion.version((String)daemonState.getVersion()).compareTo(gradleVersion_6_5) < 0);
                if (!idleDaemons.isEmpty()) {
                    GradleDaemonServices.stopDaemons(idleDaemons);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to stop Gradle daemons during project close", (Throwable)e);
        }
    }

    private void disconnectGradleConnections() {
        this.connectorsMap.values().forEach(GradleProjectConnection::disconnect);
        this.connectorsMap.clear();
    }

    private ProjectConnection getConnection(ConnectorParams connectorParams, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2, CancellationToken cancellationToken) {
        return this.connectorsMap.compute(connectorParams.projectPath, (key, conn) -> {
            if (connectorParams == (conn == null ? null : conn.params)) {
                return conn;
            }
            GradleConnector newConnector = GradleConnectorService.createConnector(connectorParams);
            ProjectConnection newConnection = newConnector.connect();
            if (newConnection == null) {
                throw new IllegalStateException("Can't create connection to the target project via gradle tooling api. Project path: '${connectorParams.projectPath}'");
            }
            GradleConnectorService.workaroundJavaVersionIssueIfNeeded(newConnection, taskId, listener2, cancellationToken);
            if (conn != null && connectorParams != conn.params) {
                WrappedConnection unwrappedConnection = (WrappedConnection)((GradleProjectConnection)conn).connection;
                unwrappedConnection.delegate.close();
            }
            WrappedConnection wrappedConnection = new WrappedConnection(newConnection);
            return new GradleProjectConnection(connectorParams, newConnector, wrappedConnection);
        }).connection;
    }

    private static GradleConnectorService getInstance(String projectPath, ExternalSystemTaskId taskId) {
        Project project;
        Project project2 = project = taskId == null ? null : taskId.findProject();
        if (project == null) {
            for (Project openProject : ProjectUtil.getOpenProjects()) {
                String projectBasePath = openProject.getBasePath();
                if (projectBasePath == null || !FileUtil.isAncestor((String)projectBasePath, (String)projectPath, (boolean)false)) continue;
                project = openProject;
                break;
            }
        }
        return project == null ? null : (GradleConnectorService)project.getService(GradleConnectorService.class);
    }

    public static <R> R withGradleConnection(String projectPath, ExternalSystemTaskId taskId, GradleExecutionSettings executionSettings, ExternalSystemTaskNotificationListener listener2, CancellationToken cancellationToken, Function<ProjectConnection, R> function) {
        ConnectorParams connectionParams = new ConnectorParams();
        connectionParams.projectPath = projectPath;
        connectionParams.serviceDirectory = executionSettings == null ? null : executionSettings.getServiceDirectory();
        connectionParams.distributionType = executionSettings == null ? null : executionSettings.getDistributionType();
        connectionParams.gradleHome = executionSettings == null ? null : executionSettings.getGradleHome();
        connectionParams.wrapperPropertyFile = executionSettings == null ? null : executionSettings.getWrapperPropertyFile();
        connectionParams.verboseProcessing = executionSettings == null ? null : Boolean.valueOf(executionSettings.isVerboseProcessing());
        connectionParams.ttlMs = executionSettings == null ? null : Integer.valueOf((int)executionSettings.getRemoteProcessIdleTtlInMs());
        GradleConnectorService connectionService = GradleConnectorService.getInstance(projectPath, taskId);
        if (connectionService != null) {
            ProjectConnection connection = connectionService.getConnection(connectionParams, taskId, listener2, cancellationToken);
            return function.apply(connection);
        }
        GradleConnector newConnector = GradleConnectorService.createConnector(connectionParams);
        ProjectConnection connection = newConnector.connect();
        GradleConnectorService.workaroundJavaVersionIssueIfNeeded(connection, taskId, listener2, cancellationToken);
        return function.apply(connection);
    }

    private static GradleConnector createConnector(ConnectorParams connectorParams) {
        int ttl;
        Application app;
        File gradleUserHome;
        GradleConnector connector = GradleConnector.newConnector();
        File projectDir = new File(connectorParams.projectPath);
        File file = gradleUserHome = connectorParams.serviceDirectory == null ? null : new File(connectorParams.serviceDirectory);
        if (connectorParams.distributionType == DistributionType.LOCAL) {
            File gradleHome;
            File file2 = gradleHome = connectorParams.gradleHome == null ? null : new File(connectorParams.gradleHome);
            if (gradleHome != null) {
                connector.useInstallation(gradleHome);
            }
        } else if (connectorParams.distributionType == DistributionType.WRAPPED && connectorParams.wrapperPropertyFile != null) {
            DistributionFactoryExt.setWrappedDistribution(connector, connectorParams.wrapperPropertyFile, gradleUserHome, projectDir);
        }
        if (gradleUserHome != null) {
            connector.useGradleUserHomeDir(gradleUserHome);
        }
        if (connectorParams.verboseProcessing.booleanValue() && connector instanceof DefaultGradleConnector) {
            ((DefaultGradleConnector)connector).setVerboseLogging(true);
        }
        int n = (app = ApplicationManager.getApplication()) != null && app.isUnitTestMode() ? 10000 : (ttl = connectorParams.ttlMs != null ? connectorParams.ttlMs : -1);
        if (ttl > 0 && connector instanceof DefaultGradleConnector) {
            ((DefaultGradleConnector)connector).daemonMaxIdleTime(ttl, TimeUnit.MILLISECONDS);
        }
        connector.forProjectDirectory(projectDir);
        return connector;
    }

    private static void workaroundJavaVersionIssueIfNeeded(ProjectConnection connection, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2, CancellationToken cancellationToken) {
        ProjectConnection unwrappedConnection = connection instanceof WrappedConnection ? ((WrappedConnection)connection).delegate : connection;
        String buildRoot = null;
        if (Registry.is((String)"gradle.java11.issue.workaround", (boolean)true) && taskId != null && listener2 != null && JavaVersion.current().feature > 8) {
            try {
                String gradleVersion;
                BuildEnvironment environment = GradleExecutionHelper.getBuildEnvironment(unwrappedConnection, taskId, listener2, cancellationToken);
                if (environment != null) {
                    try {
                        buildRoot = environment.getBuildIdentifier().getRootDir().getPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String string = environment == null ? null : (gradleVersion = environment.getGradle() == null ? null : environment.getGradle().getGradleVersion());
                if (gradleVersion == null || GradleVersion.version((String)gradleVersion).getBaseVersion().compareTo(GradleVersion.version((String)"4.7")) < 0) {
                    Field conn = (Field)ReflectionUtil.getField(unwrappedConnection.getClass(), (Object)unwrappedConnection, null, (String)"connection");
                    Field actionExecutor = (Field)ReflectionUtil.getField(conn.getClass(), (Object)conn, null, (String)"actionExecutor");
                    Field actionExecutorDelegate = (Field)ReflectionUtil.getField(actionExecutor.getClass(), (Object)actionExecutor, null, (String)"delegate");
                    Field delegateActionExecutor = (Field)ReflectionUtil.getField(actionExecutorDelegate.getClass(), (Object)actionExecutorDelegate, null, (String)"actionExecutor");
                    Field delegateActionExecutorDelegate = (Field)ReflectionUtil.getField(delegateActionExecutor.getClass(), (Object)delegateActionExecutor, null, (String)"delegate");
                    Field distributionField = ReflectionUtil.getDeclaredField(delegateActionExecutorDelegate.getClass(), (String)"distribution");
                    distributionField.set(delegateActionExecutorDelegate, new DistributionWrapper((Distribution)distributionField.get(delegateActionExecutorDelegate)));
                }
            }
            catch (Throwable t) {
                String buildId = taskId.getIdeProjectId() + StringUtil.notNullize(buildRoot);
                if (REPORTED_JAVA11_ISSUE.add(buildId)) {
                    LOG.error(t);
                }
                LOG.debug(t);
            }
        }
    }

    private static class DistributionWrapper
    implements Distribution {
        private final Distribution myDistribution;
        private final File myRtJarFile = new File(FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(MarkerRt.class)));

        DistributionWrapper(Distribution distribution) {
            this.myDistribution = distribution;
        }

        public String getDisplayName() {
            return this.myDistribution.getDisplayName();
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory factory, InternalBuildProgressListener listener2, File file, BuildCancellationToken token) {
            ClassPath classpath = this.myDistribution.getToolingImplementationClasspath(factory, listener2, file, token);
            return DefaultClassPath.of((File[])new File[]{this.myRtJarFile}).plus(classpath);
        }
    }

    private static final class ConnectorParams {
        String projectPath;
        String serviceDirectory;
        DistributionType distributionType;
        String gradleHome;
        String wrapperPropertyFile;
        Boolean verboseProcessing;
        Integer ttlMs;

        private ConnectorParams() {
        }
    }

    private static class WrappedConnection
    implements ProjectConnection {
        private final ProjectConnection delegate;

        WrappedConnection(ProjectConnection delegate) {
            this.delegate = delegate;
        }

        public <T> T getModel(Class<T> aClass) throws GradleConnectionException, IllegalStateException {
            return (T)this.delegate.getModel(aClass);
        }

        public <T> void getModel(Class<T> aClass, ResultHandler<? super T> handler) throws IllegalStateException {
            this.delegate.getModel(aClass, handler);
        }

        public BuildLauncher newBuild() {
            return this.delegate.newBuild();
        }

        public TestLauncher newTestLauncher() {
            return this.delegate.newTestLauncher();
        }

        public <T> ModelBuilder<T> model(Class<T> aClass) {
            return this.delegate.model(aClass);
        }

        public <T> BuildActionExecuter<T> action(BuildAction<T> action) {
            return this.delegate.action(action);
        }

        public BuildActionExecuter.Builder action() {
            return this.delegate.action();
        }

        public void notifyDaemonsAboutChangedPaths(List<Path> list) {
            this.delegate.notifyDaemonsAboutChangedPaths(list);
        }

        public void close() {
            throw new IllegalStateException("This connection should not be closed explicitly.");
        }
    }

    private static class GradleProjectConnection {
        final ConnectorParams params;
        final GradleConnector connector;
        private ProjectConnection connection;

        GradleProjectConnection(ConnectorParams params, GradleConnector connector, ProjectConnection connection) {
            this.params = params;
            this.connector = connector;
            this.connection = connection;
        }

        void disconnect() {
            try {
                this.connector.disconnect();
            }
            catch (Exception e) {
                LOG.warn("Failed to disconnect Gradle connector during project close. Project path: '${params.projectPath}'", (Throwable)e);
            }
        }
    }
}

