/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GroovycRunner {
    public static void main(String[] args) {
        System.exit(GroovycRunner.intMain(args));
    }

    public static int intMain(String[] args) {
        boolean indy = false;
        if (args.length != 3) {
            if (args.length != 4 || !"--indy".equals(args[3])) {
                System.err.println("There is no arguments for groovy compiler");
                return 1;
            }
            indy = true;
        }
        boolean optimize = "optimize".equals(args[0]);
        boolean forStubs = "stubs".equals(args[1]);
        String argPath = args[2];
        String configScript = System.getProperty("groovyc.config.script");
        return GroovycRunner.intMain2(indy, optimize, forStubs, argPath, configScript, null, null, System.out, System.err);
    }

    public static int intMain2(boolean indy, boolean optimize, boolean forStubs, String argPath, String configScript, @Nullable String targetBytecode, @Nullable Queue<? super Object> mailbox, @NotNull PrintStream out, @NotNull PrintStream err) {
        ClassLoader loader;
        if (indy) {
            System.setProperty("groovy.target.indy", "true");
        }
        if (!new File(argPath).exists()) {
            err.println("Arguments file for groovy compiler not found");
            return 1;
        }
        ClassLoader classLoader = loader = optimize ? GroovycRunner.buildMainLoader(argPath, err) : GroovycRunner.class.getClassLoader();
        if (loader == null) {
            err.println("Cannot find class loader for groovyc; optimized=" + optimize + "; " + GroovycRunner.class.getClassLoader());
            return 1;
        }
        if (optimize) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        try {
            Class.forName("org.codehaus.groovy.control.CompilationUnit", true, loader);
        }
        catch (Throwable e) {
            err.println("Cannot compile Groovy files: no Groovy library is defined");
            e.printStackTrace(err);
            return 1;
        }
        try {
            Class<?> aClass = Class.forName("org.jetbrains.groovy.compiler.rt.DependentGroovycRunner", true, loader);
            Method method = aClass.getDeclaredMethod("runGroovyc", Boolean.TYPE, String.class, String.class, String.class, Queue.class, PrintStream.class, PrintStream.class);
            method.invoke(null, forStubs, argPath, configScript, targetBytecode, mailbox, out, err);
        }
        catch (Throwable e) {
            while (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            e.printStackTrace(err);
            return 1;
        }
        return 0;
    }

    @Nullable
    private static ClassLoader buildMainLoader(String argsPath, PrintStream err) {
        final ArrayList<URL> urls = new ArrayList<URL>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(argsPath), Charset.forName("UTF-8")));
            String classpath = reader.readLine();
            for (String s : classpath.split(File.pathSeparator)) {
                urls.add(new File(s).toURI().toURL());
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace(err);
            return null;
        }
        final ClassLoader[] ref = new ClassLoader[1];
        new Runnable(){

            @Override
            public void run() {
                ref[0] = UrlClassLoader.build().urls(urls).useCache().allowLock().get();
            }
        }.run();
        return ref[0];
    }
}

